/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.listener;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.metainf.jira.plugin.emailissue.events.EventProcessor;
import com.metainf.jira.plugin.emailissue.listener.EventQueueStats;
import org.apache.log4j.Logger;

public class AsyncEventProcessor
implements Runnable {
    private static Logger logger = Logger.getLogger(AsyncEventProcessor.class);
    private final EventProcessor eventProcessor;
    private final IssueEvent issueEvent;
    private final ApplicationUser user;
    private final JiraAuthenticationContext authenticationContext;
    private final long timeEnqueued = System.currentTimeMillis();
    private final EventQueueStats eventQueueStats;

    public AsyncEventProcessor(EventProcessor eventProcessor, IssueEvent issueEvent, ApplicationUser user, JiraAuthenticationContext authenticationContext, EventQueueStats eventQueueStats) {
        this.eventProcessor = eventProcessor;
        this.issueEvent = issueEvent;
        this.user = user;
        this.authenticationContext = authenticationContext;
        this.eventQueueStats = eventQueueStats;
    }

    @Override
    public void run() {
        try {
            this.authenticationContext.setLoggedInUser(this.user);
            if (this.issueEvent != null) {
                this.eventProcessor.processIssueEvent(this.issueEvent);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.authenticationContext.setLoggedInUser((ApplicationUser)null);
            this.eventQueueStats.update(this);
        }
    }

    public long getTimeEnqueued() {
        return this.timeEnqueued;
    }
}

