/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.jql;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.metainf.jira.plugin.emailissue.action.EmailSource;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.jql.AbstractJetiJqlFunction;
import com.metainf.jira.plugin.emailissue.jql.AuditLogSearcher;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class IssuesSentInEmailJQLFunction
extends AbstractJetiJqlFunction {
    public IssuesSentInEmailJQLFunction(ActiveObjects ao, UserResolver userResolver, IssueSearcher issueSearcher) {
        super(ao, userResolver, issueSearcher);
    }

    public MessageSet validate(ApplicationUser user, @Nonnull FunctionOperand functionOperand, @Nonnull TerminalClause terminalClause) {
        MessageSetImpl messageSet = new MessageSetImpl();
        List args = functionOperand.getArgs();
        if (args.size() <= 0 || StringUtils.isNotBlank((String)((String)args.get(0)))) {
            // empty if block
        }
        if (messageSet.hasAnyErrors()) {
            messageSet.addErrorMessage("The usage is: " + this.getFunctionName() + "(Email sddress of the sender, Date from, Date to, email subject containing), all parameters are optional, user \"\" for empty parameters. Date parameters must be of format dd/MM/yyyy or of durations like -5d");
        }
        return messageSet;
    }

    @Override
    protected AuditLogSearcher createSearcher(List<String> args) {
        AuditLogSearcher als = new AuditLogSearcher().as(AuditLogEntry.EmailType.OUTGOING);
        this.parseArgs(als, args);
        return als;
    }

    private void parseArgs(AuditLogSearcher als, List<String> args) {
        if (!args.isEmpty() && StringUtils.isNotBlank((String)args.get(0))) {
            String params = args.get(0);
            if (params.contains(",") || params.contains("=")) {
                String[] tokens;
                for (String token : tokens = params.split(",")) {
                    if (!(token = token.trim()).contains("=")) continue;
                    int pos = token.indexOf("=");
                    String key = token.substring(0, pos);
                    String val = token.substring(pos + 1);
                    if ("to".equalsIgnoreCase(key)) {
                        als.to(val);
                        continue;
                    }
                    if ("cc".equalsIgnoreCase(key)) {
                        als.cc(val);
                        continue;
                    }
                    if ("bcc".equalsIgnoreCase(key)) {
                        als.bcc(val);
                        continue;
                    }
                    if ("sender".equalsIgnoreCase(key)) {
                        als.sender(val);
                        continue;
                    }
                    if ("dateFrom".equalsIgnoreCase(key)) {
                        als.after(this.resolveDate(val));
                        continue;
                    }
                    if ("dateTo".equalsIgnoreCase(key)) {
                        als.before(this.resolveDate(val));
                        continue;
                    }
                    if ("source".equalsIgnoreCase(key)) {
                        als.source(EmailSource.valueOf(val, EmailSource.OPERATION));
                        continue;
                    }
                    if ("subject".equalsIgnoreCase(key)) {
                        als.containing(val);
                        continue;
                    }
                    if (!"issue".equalsIgnoreCase(key)) continue;
                    als.issue(val);
                }
            } else {
                als.sentTo(params);
            }
        }
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 0;
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.ISSUE;
    }
}

