/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.jql;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.jql.AbstractJetiJqlFunction;
import com.metainf.jira.plugin.emailissue.jql.AuditLogSearcher;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class IssuesCreatedByEmailJQLFunction
extends AbstractJetiJqlFunction {
    public IssuesCreatedByEmailJQLFunction(ActiveObjects ao, UserResolver userResolver, IssueSearcher issueSearcher) {
        super(ao, userResolver, issueSearcher);
    }

    public MessageSet validate(ApplicationUser user, @Nonnull FunctionOperand functionOperand, @Nonnull TerminalClause terminalClause) {
        MessageSetImpl messageSet = new MessageSetImpl();
        List args = functionOperand.getArgs();
        if (args.size() > 0 && StringUtils.isNotBlank((String)((String)args.get(0))) && !this.userResolver.isEmailAddress((String)args.get(0)) && !this.userResolver.isExtendedEmailAddress((String)args.get(0))) {
            messageSet.addErrorMessage("The first parameter of " + this.getFunctionName() + " must be a valid email address");
        }
        if (args.size() > 1 && StringUtils.isNotBlank((String)((String)args.get(1))) && this.resolveDate((String)args.get(1)) == null) {
            messageSet.addErrorMessage("The second parameter of " + this.getFunctionName() + " must be a date (e.g. 31/03/2014) or a valid duration (e.g. -5d)");
        }
        if (args.size() > 2 && StringUtils.isNotBlank((String)((String)args.get(2))) && this.resolveDate((String)args.get(2)) == null) {
            messageSet.addErrorMessage("The third parameter of " + this.getFunctionName() + " must be a date (e.g. 31/03/2014) or a valid duration (e.g. -5d)");
        }
        if (messageSet.hasAnyErrors()) {
            messageSet.addErrorMessage("The usage is: " + this.getFunctionName() + "(Email sddress of the sender, Date from, Date to, email subject containing), all parameters are optional, user \"\" for empty parameters. Date parameters must be of format dd/MM/yyyy or of durations like -5d");
        }
        return messageSet;
    }

    @Override
    protected AuditLogSearcher createSearcher(List<String> args) {
        AuditLogSearcher als = new AuditLogSearcher().as(AuditLogEntry.EmailType.INCOMING_ISSUE);
        if (args != null && !args.isEmpty()) {
            if (args.size() > 0 && StringUtils.isNotBlank((String)args.get(0))) {
                als.from(args.get(0));
            }
            if (args.size() > 3 && StringUtils.isNotBlank((String)args.get(3))) {
                als.containing(args.get(3));
            }
            String from = args.size() > 1 && StringUtils.isNotBlank((String)args.get(1)) ? args.get(1) : null;
            String to = args.size() > 2 && StringUtils.isNotBlank((String)args.get(2)) ? args.get(2) : null;
            als.between(this.resolveDate(from), this.resolveDate(to));
        }
        return als;
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 0;
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.ISSUE;
    }
}

