/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.jql;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.metainf.jira.plugin.emailissue.action.EmailSource;
import com.metainf.jira.plugin.emailissue.entity.AuditLogDao;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.apache.commons.lang.time.DateUtils;

public class AuditLogSearcher {
    private String from;
    private Date dateFrom;
    private Date dateTo;
    private String subject;
    private AuditLogEntry.EmailType emailType;
    private String recipient;
    private String to;
    private String cc;
    private String bcc;
    private String sender;
    private EmailSource source;
    private String issueKey;

    public AuditLogSearcher issue(String issueKey) {
        this.issueKey = issueKey;
        return this;
    }

    public AuditLogSearcher sentTo(String recipient) {
        this.recipient = recipient;
        return this;
    }

    public AuditLogSearcher to(String to) {
        this.to = to;
        return this;
    }

    public AuditLogSearcher cc(String cc) {
        this.cc = cc;
        return this;
    }

    public AuditLogSearcher bcc(String bcc) {
        this.bcc = bcc;
        return this;
    }

    public AuditLogSearcher sender(String sender) {
        this.sender = sender;
        return this;
    }

    public AuditLogSearcher source(EmailSource source) {
        this.source = source;
        return this;
    }

    public AuditLogSearcher from(String from) {
        this.from = from;
        return this;
    }

    public AuditLogSearcher after(Date from) {
        this.dateFrom = from;
        return this;
    }

    public AuditLogSearcher before(Date dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    public AuditLogSearcher between(Date from, Date to) {
        this.dateFrom = from;
        this.dateTo = to;
        return this;
    }

    public AuditLogSearcher containing(String text) {
        this.subject = text;
        return this;
    }

    public AuditLogSearcher as(AuditLogEntry.EmailType emailType) {
        this.emailType = emailType;
        return this;
    }

    public Collection<AuditLogEntry> search(@Nonnull AuditLogDao auditLogDao) {
        AuditLogEntry[] hits;
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuilder where = new StringBuilder();
        where.append("TYPE = ?");
        args.add((Object)this.emailType);
        if (StringUtils.isNotBlank((String)this.from)) {
            this.append(where, "FROM = ?");
            args.add(this.from);
        }
        if (this.dateFrom != null) {
            this.append(where, "SEND_TIME_STAMP >= ?");
            args.add(this.dateFrom);
        }
        if (this.dateTo != null) {
            this.append(where, "SEND_TIME_STAMP < ?");
            args.add(DateUtils.addDays((Date)this.dateTo, (int)1));
        }
        if (StringUtils.isNotBlank((String)this.subject)) {
            this.append(where, "EMAIL_SUBJECT LIKE ?");
            args.add(this.subject);
        }
        if (StringUtils.isNotBlank((String)this.issueKey)) {
            this.append(where, "ISSUE_KEY = ?");
            args.add(this.issueKey);
        }
        if (StringUtils.isNotBlank((String)this.recipient)) {
            this.append(where, "(TO LIKE ? OR CC LIKE ? OR BCC LIKE ?)");
            args.add("%" + this.recipient + "%");
            args.add("%" + this.recipient + "%");
            args.add("%" + this.recipient + "%");
        } else if (StringUtils.isNotBlank((String)this.to)) {
            this.append(where, "TO LIKE ?");
            args.add("%" + this.to + "%");
        } else if (StringUtils.isNotBlank((String)this.cc)) {
            this.append(where, "CC LIKE ?");
            args.add("%" + this.cc + "%");
        } else if (StringUtils.isNotBlank((String)this.bcc)) {
            this.append(where, "BCC LIKE ?");
            args.add("%" + this.bcc + "%");
        }
        if (StringUtils.isNotBlank((String)this.sender)) {
            this.append(where, "(SENDER_NAME = ? OR SENDER_KEY = ?)");
            args.add(this.sender);
            args.add(this.sender);
        }
        if (this.source != null) {
            this.append(where, "SOURCE = ?");
            args.add(this.source.name());
        }
        return (hits = (AuditLogEntry[])auditLogDao.filter(where.toString(), args.toArray())) != null ? new HashSet<AuditLogEntry>(Arrays.asList(hits)) : Collections.EMPTY_SET;
    }

    private void append(StringBuilder sb, String newValue) {
        if (sb.length() > 0) {
            sb.append(" AND ");
        }
        sb.append(newValue);
    }
}

