/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.jql;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.entity.AuditLogDao;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.jql.AuditLogSearcher;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractJetiJqlFunction
extends AbstractJqlFunction {
    private final ActiveObjects ao;
    protected final UserResolver userResolver;
    protected final AuditLogDao auditLogDao;
    private static final String DATE_FORMAT = "dd/MM/yyyy";
    private final IssueSearcher issueSearcher;

    protected AbstractJetiJqlFunction(ActiveObjects ao, UserResolver userResolver, IssueSearcher issueSearcher) {
        this.ao = ao;
        this.userResolver = userResolver;
        this.issueSearcher = issueSearcher;
        this.auditLogDao = new AuditLogDao(ao);
    }

    protected Collection<AuditLogEntry> searchAuditLog(AuditLogSearcher searcher) {
        return searcher.search(this.auditLogDao);
    }

    protected Collection<Long> searchAuditLogForIssues(AuditLogSearcher searcher) {
        Collection<AuditLogEntry> entries = this.searchAuditLog(searcher);
        ArrayList<Long> issueIds = new ArrayList<Long>(entries.size());
        for (AuditLogEntry ale : entries) {
            if (ale.getIssueId() == null || !this.issueSearcher.issueExists(ale.getIssueId())) continue;
            issueIds.add(ale.getIssueId());
        }
        return issueIds;
    }

    public List<QueryLiteral> getValues(@Nonnull QueryCreationContext queryCreationContext, @Nonnull FunctionOperand functionOperand, @Nonnull TerminalClause terminalClause) {
        Assertions.notNull((String)"queryCreationContext", (Object)queryCreationContext);
        LinkedList<QueryLiteral> literals = new LinkedList<QueryLiteral>();
        List args = functionOperand.getArgs();
        AuditLogSearcher als = this.createSearcher(args);
        Collection<Long> issueIds = this.searchAuditLogForIssues(als);
        for (Long iid : issueIds) {
            literals.add(new QueryLiteral((Operand)functionOperand, iid));
        }
        return literals;
    }

    protected abstract AuditLogSearcher createSearcher(List<String> var1);

    protected Date resolveDate(String dateString) {
        if (StringUtils.isNotBlank((CharSequence)dateString)) {
            Date date = this.parseDate(dateString);
            if (date == null) {
                dateString = (dateString = dateString.trim()).startsWith("-") ? dateString.substring(1) : dateString;
                try {
                    long seconds = DateUtils.getDuration((String)dateString);
                    Calendar cal = Calendar.getInstance();
                    cal.add(13, -1 * new Long(seconds).intValue());
                    date = cal.getTime();
                }
                catch (InvalidDurationException invalidDurationException) {
                    // empty catch block
                }
            }
            return date;
        }
        return null;
    }

    protected Date parseDate(String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        try {
            return sdf.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

