/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler.webwork;

import com.atlassian.jira.plugins.mail.extensions.MessageHandlerModuleDescriptor;
import com.atlassian.jira.service.services.file.FileService;
import com.atlassian.jira.service.services.mail.MailFetcherService;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.mail.MailException;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.metainf.jira.plugin.emailissue.util.ReflectionUtil;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ServiceConfigurationWrapper {
    public static final String ID = "com.atlassian.jira.plugins.mail.ServiceConfiguration";
    private Object delegate;

    public ServiceConfigurationWrapper(Object delegate) {
        this.delegate = delegate;
    }

    public Object getServiceConfigurationObject() {
        return this.delegate;
    }

    @Nullable
    public Long getServiceId() {
        return ReflectionUtil.getLong(this.delegate, "serviceId");
    }

    public void setServiceId(@Nullable Long serviceId) {
        ReflectionUtil.setLong(this.delegate, "serviceId", serviceId);
    }

    public void setHandlerKey(@Nonnull String handler) {
        ReflectionUtil.setString(this.delegate, "handlerKey", handler);
    }

    @Nonnull
    public String getHandlerKey() {
        return ReflectionUtil.getStringProperty(this.delegate, "handlerKey");
    }

    @Nonnull
    public String getServiceName() {
        return ReflectionUtil.getStringProperty(this.delegate, "serviceName");
    }

    public void setServiceName(@Nonnull String serviceName) {
        ReflectionUtil.setString(this.delegate, "serviceName", serviceName);
    }

    public long getDelay() {
        Long v = ReflectionUtil.getLong(this.delegate, "delay");
        return v == null ? 0L : v;
    }

    public void setDelay(long delay) {
        ReflectionUtil.setLong(this.delegate, "delay", delay);
    }

    public void setFolder(@Nullable String folder) {
        ReflectionUtil.setString(this.delegate, "folder", folder);
    }

    @Nullable
    public String getFolder() {
        return ReflectionUtil.getStringProperty(this.delegate, "folder");
    }

    public void setServerId(@Nullable Long serverId) {
        ReflectionUtil.setLong(this.delegate, "serviceId", serverId);
    }

    @Nullable
    public Long getServerId() {
        return ReflectionUtil.getLong(this.delegate, "serverId");
    }

    @Nonnull
    public Map<String, String[]> toServiceParams(@Nonnull PluginAccessor pa) throws MailException {
        return Maps.transformValues(this.toMap(pa), (Function)new Function<String, String[]>(){

            public String[] apply(@Nullable String from) {
                return new String[]{from};
            }
        });
    }

    @Nonnull
    public Map<String, String> toMap(@Nonnull PluginAccessor pa) throws MailException {
        MapBuilder builder = MapBuilder.newBuilder();
        MessageHandlerModuleDescriptor enabledPluginModule = (MessageHandlerModuleDescriptor)pa.getEnabledPluginModule(this.getHandlerKey());
        if (enabledPluginModule != null) {
            builder.add((Object)"handler", (Object)enabledPluginModule.getMessageHandler().getName());
        }
        if (this.getServerId() != null) {
            builder.add((Object)"popserver", (Object)Long.toString(this.getServerId())).add((Object)"foldername", (Object)this.getFolder());
        } else {
            builder.add((Object)"subdirectory", (Object)this.getFolder());
        }
        return builder.toMutableMap();
    }

    @Nonnull
    public String getServiceClass() {
        return (this.getServerId() == null ? FileService.class : MailFetcherService.class).getName();
    }
}

