/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler.webwork;

import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metainf.jira.plugin.emailissue.handler.webwork.AbstractEditHandlerDetailsWebAction;
import com.metainf.jira.plugin.emailissue.handler.webwork.HandlerDetailsModel;
import com.metainf.jira.plugin.emailissue.handler.webwork.IssueTypeModel;
import com.metainf.jira.plugin.emailissue.handler.webwork.OptionModel;
import com.metainf.jira.plugin.emailissue.handler.webwork.ProjectModel;
import com.metainf.jira.plugin.emailissue.util.ReflectionUtil;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

@WebSudoRequired
public class EditHandlerDetailsWebAction
extends AbstractEditHandlerDetailsWebAction {
    private static final Map<String, String> fieldLabels = ImmutableMap.builder().put((Object)"project", (Object)"common.concepts.project").put((Object)"issuetype", (Object)"common.concepts.issuetype").put((Object)"stripquotes", (Object)"jmp.editHandlerDetails.stripquotes").put((Object)"reporterusername", (Object)"jmp.editHandlerDetails.reporterusername").put((Object)"splitregex", (Object)"jmp.editHandlerDetails.splitregex").put((Object)"catchemail", (Object)"jmp.editHandlerDetails.catchemail").put((Object)"bulk", (Object)"jmp.editHandlerDetails.bulk").put((Object)"forwardEmail", (Object)"admin.service.common.handler.forward.email").put((Object)"createusers", (Object)"jmp.editHandlerDetails.createusers").put((Object)"notifyusers", (Object)"jmp.editHandlerDetails.notifyusers").put((Object)"ccassignee", (Object)"jmp.editHandlerDetails.ccassignee").put((Object)"ccwatcher", (Object)"jmp.editHandlerDetails.ccwatcher").put((Object)"port", (Object)"jmp.editHandlerDetails.port").put((Object)"usessl", (Object)"jmp.editHandlerDetails.usessl").build();
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private HandlerDetailsModel details;
    private final List<Project> projects;
    private String detailsJson;
    private final UserManager userManager;

    public EditHandlerDetailsWebAction(IssueTypeSchemeManager issueTypeSchemeManager, ProjectManager projectManager, PluginAccessor pluginAccessor, UserManager userManager) {
        super(pluginAccessor);
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.details = new HandlerDetailsModel();
        this.details.setNotifyusers(true);
        this.userManager = userManager;
        this.projects = projectManager.getProjectObjects();
    }

    @Override
    protected void copyServiceSettings(JiraServiceContainer serviceContainer) throws ObjectConfigurationException {
        this.details.setForwardEmail(serviceContainer.getProperty("forwardEmail"));
        this.details.fromServiceParams(serviceContainer.getProperty("handler.params"));
    }

    @Override
    protected Map<String, String> getHandlerParams() {
        return this.details.toServiceParams();
    }

    @Override
    protected Map<String, String[]> getAdditionalServiceParams() throws Exception {
        return MapBuilder.newBuilder((Object)"forwardEmail", (Object)new String[]{this.details.getForwardEmail()}).toMutableMap();
    }

    protected void doValidation() {
        if (this.configuration == null) {
            return;
        }
        super.doValidation();
        if (this.detailsJson == null) {
            this.addErrorMessage("No configuration data sent via detailsJson field.");
            return;
        }
        try {
            this.details = (HandlerDetailsModel)new ObjectMapper().readValue(this.detailsJson, HandlerDetailsModel.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.addErrorCollection(this.validateDetails(this.details));
    }

    public ErrorCollection validateDetails(HandlerDetailsModel details) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nHelper = this.getI18nHelper();
        if (details.isCreateusers()) {
            boolean extUserMgmt;
            boolean bl = extUserMgmt = !this.userManager.hasWritableDirectory();
            if (StringUtils.isNotBlank((CharSequence)details.getReporterusername())) {
                if (extUserMgmt) {
                    errorCollection.addError("createusers", i18nHelper.getText("jmp.editHandlerDetails.error.external.user"));
                } else {
                    errorCollection.addError("reporterusername", i18nHelper.getText("jmp.editHandlerDetails.create.users.is.enabled"));
                }
            } else if (extUserMgmt) {
                errorCollection.addError("createusers", i18nHelper.getText("jmp.editHandlerDetails.cant.create.users"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)details.getReporterusername()) && this.userManager.getUserByName(details.getReporterusername()) == null) {
            errorCollection.addError("reporterusername", i18nHelper.getText("admin.errors.users.user.does.not.exist"));
        }
        if (StringUtils.isNotBlank((CharSequence)details.getCatchemail()) && !TextUtils.verifyEmail((String)TextUtils.noNull((String)details.getCatchemail()).trim())) {
            errorCollection.addError("catchemail", i18nHelper.getText("admin.errors.invalid.email"));
        }
        if ("forward".equals(details.getBulk()) && StringUtils.isBlank((CharSequence)details.getForwardEmail())) {
            errorCollection.addError("bulk", i18nHelper.getText("jmp.editHandlerDetails.forwardEmail.is.not.set"));
        }
        if (StringUtils.isNotBlank((CharSequence)details.getForwardEmail()) && !TextUtils.verifyEmail((String)TextUtils.noNull((String)details.getForwardEmail()).trim())) {
            errorCollection.addError("forwardEmail", i18nHelper.getText("admin.errors.invalid.email"));
        }
        return errorCollection;
    }

    public static Map<String, String> getFieldLabels() {
        return fieldLabels;
    }

    public void setDetailsJson(String json) {
        this.detailsJson = json;
    }

    @Nonnull
    public String getDetailsJson() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this.details);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public String getBulkOptionsJson() {
        ArrayList options = Lists.newArrayList((Object[])new OptionModel[]{new OptionModel(this.getText("jmp.editHandlerDetails.bulk.ignore"), "ignore"), new OptionModel(this.getText("jmp.editHandlerDetails.bulk.forward"), "forward"), new OptionModel(this.getText("jmp.editHandlerDetails.bulk.delete"), "delete"), new OptionModel(this.getText("jmp.editHandlerDetails.bulk.accept"), "accept")});
        try {
            return new ObjectMapper().writeValueAsString((Object)options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public String getProjectsJson() {
        ArrayList suggestions = Lists.newArrayList((Iterable)Iterables.transform(this.projects, (Function)new Function<Project, ProjectModel>(){

            public ProjectModel apply(Project project) {
                return new ProjectModel(project.getName(), project.getKey(), Lists.newArrayList((Iterable)Iterables.transform((Iterable)EditHandlerDetailsWebAction.this.issueTypeSchemeManager.getIssueTypesForProject(project), (Function)new Function<IssueType, IssueTypeModel>(){

                    public IssueTypeModel apply(IssueType from) {
                        return new IssueTypeModel(from.getName(), from.getId());
                    }
                })));
            }
        }));
        try {
            return new ObjectMapper().writeValueAsString((Object)suggestions);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isCreateOrCommentHandlerSelected() {
        String className = ReflectionUtil.getStringProperty(this.descriptor, "messageHandler.name");
        return className != null && className.contains("CreateOrCommentHandler");
    }

    public boolean isCreateIssueHandlerSelected() {
        String className = ReflectionUtil.getStringProperty(this.descriptor, "messageHandler.name");
        return className != null && className.contains("CreateIssueHandler");
    }

    public boolean isRegexCommentHandlerSelected() {
        String className = ReflectionUtil.getStringProperty(this.descriptor, "messageHandler.name");
        return className != null && className.contains("RegexCommentHandler");
    }
}

