/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.user.ApplicationUser;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskDetails;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManagerImpl;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.handler.AbstractMailHandler;
import com.metainf.jira.plugin.emailissue.handler.AbstractMessageHandler;
import com.metainf.jira.plugin.emailissue.handler.IssueSupportingMessageHandlerContext;
import com.metainf.jira.plugin.emailissue.handler.RegexSupportingCreateOrCommentHandler;
import com.metainf.jira.plugin.emailissue.handler.ReporterResolvingCreateIssueHandler;
import com.metainf.jira.plugin.emailissue.handler.ReporterResolvingCreateOrCommentHandler;
import com.metainf.jira.plugin.emailissue.handler.ServiceDeskCommentHandler;
import com.metainf.jira.plugin.emailissue.handler.ServiceDeskCreateIssueHandler;
import com.metainf.jira.plugin.emailissue.mail.EmailBean;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import com.metainf.jira.plugin.emailissue.template.MailTemplateManager;
import com.metainf.jira.plugin.emailissue.workflow.IssueTransitioner;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ServiceDeskHandler
extends AbstractMailHandler {
    private Logger logger = Logger.getLogger(this.getClass());
    private final IssueLinkManager issueLinkManager;
    private final IssueSearcher issueSearcher;
    private final ServiceDeskManager serviceDeskManager;
    private final ProjectManager projectManager;
    private final ProjectRoleManager projectRoleManager;
    private final PermissionManager permissionManager;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final Project projectForHandler;
    private final MailTemplateManager mailTemplateManager;
    private final CustomFieldManager customFieldManager;
    private final IssueTransitioner issueTransitioner;
    private Issue issueAffectedByMessage;
    private ServiceDeskDetails serviceDesk;

    public ServiceDeskHandler(AutoReplyParams mailHandlerContext, IssueLinkManager issueLinkManager, IssueSearcher issueSearcher, FieldContextProcessor fieldContextProcessor, MailTemplateManager mailTemplateManager, IssueTransitioner issueTransitioner, ActiveObjects ao) {
        super(mailHandlerContext, fieldContextProcessor);
        this.mailTemplateManager = mailTemplateManager;
        this.issueLinkTypeManager = (IssueLinkTypeManager)ComponentAccessor.getComponent(IssueLinkTypeManager.class);
        this.permissionManager = ComponentAccessor.getPermissionManager();
        this.projectManager = ComponentAccessor.getProjectManager();
        this.projectRoleManager = (ProjectRoleManager)ComponentAccessor.getComponentOfType(ProjectRoleManager.class);
        this.serviceDeskManager = new ServiceDeskManagerImpl(ComponentAccessor.getProjectManager(), ComponentAccessor.getOfBizDelegator(), ComponentAccessor.getPluginAccessor(), this.projectRoleManager, ao, (UserService)ComponentAccessor.getComponentOfType(UserService.class));
        this.issueLinkManager = issueLinkManager;
        this.issueSearcher = issueSearcher;
        this.projectForHandler = mailHandlerContext.getProjectId() == null ? null : this.projectManager.getProjectObj(mailHandlerContext.getProjectId());
        this.customFieldManager = ComponentAccessor.getCustomFieldManager();
        this.issueTransitioner = issueTransitioner;
    }

    @Override
    public boolean handleMessage(Message message, IssueSupportingMessageHandlerContext messageHandlerContext, Issue issue) throws MessagingException {
        this.logger.debug((Object)(".handleMessage() called: " + (message != null ? message.getSubject() : "null message")));
        this.logger.info((Object)("Issue for message: " + message.getSubject() + ": " + issue));
        MessageHandler handler = null;
        boolean messageProcessed = false;
        this.issueAffectedByMessage = issue;
        this.serviceDesk = this.serviceDeskManager.getServiceDeskDetails(issue == null ? this.mailHandlerContext.getProjectId() : issue.getProjectId());
        this.logger.debug((Object)("Service Desk Details. " + this.serviceDesk));
        if (this.mailHandlerContext.getIssueTypeId() == null || this.mailHandlerContext.getProjectId() == null || this.serviceDesk == null || issue != null && !this.mailHandlerContext.getProjectId().equals(issue.getProjectId())) {
            handler = this.createFallbackHandler(issue);
            handler.init(this.params, this.errorCollector);
            this.logger.debug((Object)("Using fallback handler: " + handler));
            messageProcessed = handler.handleMessage(message, (MessageHandlerContext)messageHandlerContext);
        } else {
            handler = this.createServiceDeskHandler(issue, this.serviceDesk);
            this.logger.debug((Object)("Using handler: " + handler));
            handler.init(this.params, this.errorCollector);
            messageProcessed = handler.handleMessage(message, (MessageHandlerContext)messageHandlerContext);
        }
        this.logger.debug((Object)("Message processed: " + messageProcessed));
        if (messageProcessed && messageHandlerContext.getIssueAffected() != null && issue != null && !messageHandlerContext.getIssueAffected().getId().equals(issue.getId()) && this.processingType.isLinkEnabled() && this.mailHandlerContext.getLinkType() != null && this.mailHandlerContext.getLinkType() > 0L && this.issueLinkTypeManager.getIssueLinkType(this.mailHandlerContext.getLinkType()) != null) {
            this.issueAffectedByMessage = messageHandlerContext.getIssueAffected();
            try {
                this.issueLinkManager.createIssueLink(this.issueAffectedByMessage.getId(), issue.getId(), this.mailHandlerContext.getLinkType(), Long.valueOf(10L), this.issueAffectedByMessage.getReporter());
                this.logger.debug((Object)("Issue linked to: " + this.issueAffectedByMessage));
            }
            catch (CreateException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return messageProcessed;
    }

    @Override
    protected Issue lookupIssueUponFieldRules(Message message) throws MessagingException {
        ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
        if (user == null) {
            user = this.getMessageUserProcessor().getAuthorFromSender(message);
        }
        if (user == null || this.projectForHandler == null || !this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, this.projectForHandler, user)) {
            user = this.getDefaultReporter();
        }
        Issue issue = this.fieldContextProcessor.lookupIssue(this.mailHandlerContext.getProjectId(), this.mailHandlerContext.getIssueTypeId(), new EmailBean(message), user);
        this.logger.debug((Object)("Lookup Rule found issue: " + issue));
        return issue;
    }

    private MessageHandler createServiceDeskHandler(Issue issue, ServiceDeskDetails serviceDeskDetails) {
        Object handler = null;
        handler = issue == null ? new ServiceDeskCreateIssueHandler(serviceDeskDetails, this.mailHandlerContext, this.serviceDeskManager, this.projectRoleManager, this.projectManager) : (!this.processingType.isCommentCriteriaEnabled() || StringUtils.isBlank((String)this.mailHandlerContext.getCommentCriteria()) || this.issueSearcher.issueMatchesJQLWithoutReindexing(this.mailHandlerContext.getCommentCriteria(), issue, true) ? new ServiceDeskCommentHandler(issue, this.mailHandlerContext, this.fieldContextProcessor, this.serviceDeskManager, ComponentAccessor.getCustomFieldManager(), this.issueTransitioner, ComponentAccessor.getIssueManager()) : new ServiceDeskCreateIssueHandler(serviceDeskDetails, this.mailHandlerContext, this.serviceDeskManager, this.projectRoleManager, this.projectManager));
        return handler;
    }

    private MessageHandler createFallbackHandler(Issue issue) {
        AbstractMessageHandler handler;
        if (issue == null) {
            handler = new ReporterResolvingCreateIssueHandler(this.fieldContextProcessor, this.mailHandlerContext);
        } else if (!this.processingType.isCommentCriteriaEnabled() || StringUtils.isBlank((String)this.mailHandlerContext.getCommentCriteria()) || this.issueSearcher.issueMatchesJQLWithoutReindexing(this.mailHandlerContext.getCommentCriteria(), issue, true)) {
            String[] regex;
            String[] stringArray = regex = StringUtils.isNotBlank((String)this.mailHandlerContext.getSplitregex()) ? this.mailHandlerContext.getSplitregex().split("\r\n") : null;
            handler = regex == null ? new ReporterResolvingCreateOrCommentHandler(this.fieldContextProcessor, this.mailHandlerContext){

                @Override
                protected Issue getAssociatedIssue(Message message) {
                    return ServiceDeskHandler.this.issueAffectedByMessage;
                }
            } : new RegexSupportingCreateOrCommentHandler(regex, this.mailHandlerContext, this.fieldContextProcessor){

                @Override
                protected Issue getAssociatedIssue(Message message) {
                    return ServiceDeskHandler.this.issueAffectedByMessage;
                }
            };
        } else {
            handler = new ReporterResolvingCreateIssueHandler(this.fieldContextProcessor, this.mailHandlerContext);
        }
        handler.init(this.params, this.errorCollector);
        return handler;
    }
}

