/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.metainf.jira.plugin.emailissue.desk.CustomerRequestType;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskDetails;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.handler.CreateIssueHandler;
import com.metainf.jira.plugin.emailissue.handler.IssueSupportingMessageHandlerContext;
import com.metainf.jira.plugin.emailissue.handler.MailUtil;
import com.metainf.jira.plugin.emailissue.util.CollectionUtils;
import com.metainf.jira.plugin.emailissue.util.CustomFieldUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ServiceDeskCreateIssueHandler
extends CreateIssueHandler {
    private Logger logger = Logger.getLogger(this.getClass());
    private final ProjectManager projectManager;
    private final ProjectRoleManager projectRoleManager;
    private final AutoReplyParams mailHandlerContext;
    private final ServiceDeskManager serviceDeskManager;
    private ApplicationUser reporterUser;
    private final ServiceDeskDetails serviceDesk;
    private Message messageBeingProcessed;

    public ServiceDeskCreateIssueHandler(@Nonnull ServiceDeskDetails serviceDesk, @Nonnull AutoReplyParams mailHandlerContext, @Nonnull ServiceDeskManager serviceDeskManager, @Nonnull ProjectRoleManager projectRoleManager, @Nonnull ProjectManager projectManager) {
        this.projectManager = projectManager;
        this.serviceDesk = serviceDesk;
        this.projectRoleManager = projectRoleManager;
        this.mailHandlerContext = mailHandlerContext;
        this.serviceDeskManager = serviceDeskManager;
    }

    @Override
    public boolean handleMessage(Message message, MessageHandlerContext context) throws MessagingException {
        if (this.getReporter(message, context) == null) {
            return false;
        }
        this.logger.debug((Object)"handleMessage() called");
        this.messageBeingProcessed = message;
        boolean messageProcessed = super.handleMessage(message, context);
        this.logger.debug((Object)("message processed: " + messageProcessed));
        if (messageProcessed && context instanceof IssueSupportingMessageHandlerContext && ((IssueSupportingMessageHandlerContext)context).getIssueAffected() != null) {
            Issue issue = ((IssueSupportingMessageHandlerContext)context).getIssueAffected();
            List<String> attachmentNames = ((IssueSupportingMessageHandlerContext)context).getAttachmentNames();
            if (issue.getReporter() != null && attachmentNames != null && !attachmentNames.isEmpty() && this.serviceDeskManager.userHasPortalAccess(issue.getReporter(), issue.getProjectObject(), this.serviceDesk)) {
                StringBuilder attachmentLinks = new StringBuilder("\n\r\n\r");
                for (String attachmentName : attachmentNames) {
                    attachmentLinks.append("[^").append(attachmentName).append("]\n\r\n\r");
                }
                ComponentAccessor.getCommentManager().create(issue, issue.getReporter(), attachmentLinks.toString(), false);
            }
            this.serviceDeskManager.setChannelType(issue, issue.getReporter());
        }
        return messageProcessed;
    }

    @Override
    protected Issue createIssueInContext(MessageHandlerContext context, ApplicationUser reporter, MutableIssue issueObject) throws CreateException {
        String customerRequestTypeKey = null;
        this.logger.debug((Object)".createIssueInContext() called");
        if (StringUtils.isNotBlank((String)this.mailHandlerContext.getRequestTypeKey())) {
            for (CustomerRequestType customerRequestType : this.serviceDeskManager.getCustomerRequestTypesForIssue((Issue)issueObject)) {
                if (!customerRequestType.getKey().equalsIgnoreCase(this.mailHandlerContext.getRequestTypeKey())) continue;
                customerRequestTypeKey = customerRequestType.getKey();
                break;
            }
        }
        String string = customerRequestTypeKey = customerRequestTypeKey == null ? this.serviceDeskManager.getCustomerRequestTypeForIssue((Issue)issueObject) : customerRequestTypeKey;
        if (StringUtils.isNotBlank((String)customerRequestTypeKey)) {
            Object value;
            this.logger.debug((Object)("setting Request Type: " + customerRequestTypeKey));
            List customFieldObjects = ComponentAccessor.getCustomFieldManager().getCustomFieldObjects((Issue)issueObject);
            CustomField customerRequestTypeField = CustomFieldUtil.getServiceDeskCustomerRequestTypeField(customFieldObjects);
            if (customerRequestTypeField != null && (value = customerRequestTypeField.getCustomFieldType().getSingularObjectFromString(customerRequestTypeKey)) != null) {
                issueObject.setCustomFieldValue(customerRequestTypeField, value);
            }
        }
        ApplicationUser actingUser = reporter;
        if (!(this.reporteruserName == null || this.getPermissionManager().hasPermission(ProjectPermissions.CREATE_ISSUES, issueObject.getProjectObject(), this.reporterUser, true) && this.reporterUser.getDirectoryUser().getDirectoryId() != -1L)) {
            actingUser = UserUtils.getUser((String)this.reporteruserName);
        }
        this.logger.debug((Object)"About to add participants");
        Collection<ApplicationUser> addedParticipants = this.addParticipants(this.messageBeingProcessed, issueObject, this.serviceDesk, actingUser);
        this.logger.debug((Object)"About to call context.createIssue");
        Issue createdIssue = context.createIssue(actingUser, (Issue)issueObject);
        this.serviceDeskManager.sendParticipantAddedEmail(createdIssue, this.serviceDesk, addedParticipants, actingUser, this.mailHandlerContext.getParticipantAddedTemplateId());
        return createdIssue;
    }

    private Collection<ApplicationUser> addParticipants(Message message, MutableIssue issue, ServiceDeskDetails serviceDesk, ApplicationUser actingUser) {
        HashSet<String> allRecipientEmailAddresses = MailUtil.getEmailAddresses(message, MimeMessage.RecipientType.TO, MimeMessage.RecipientType.CC);
        HashSet<String> excludeEmails = StringUtils.isNotBlank((String)this.mailHandlerContext.getExcludeEmailsRegex()) ? new HashSet<String>(Arrays.asList(this.mailHandlerContext.getExcludeEmailsRegex().toLowerCase().split("\r\n"))) : new HashSet();
        CollectionUtils.removeAllIgnoreCase(allRecipientEmailAddresses, (Collection<String>)excludeEmails);
        return this.serviceDeskManager.addParticipantsInIssue(issue, serviceDesk, allRecipientEmailAddresses, actingUser, this.mailHandlerContext.getCustomerCreatedTemplateId());
    }

    @Override
    protected boolean reporterHasCreatePermission(Project project, ApplicationUser reporterUser) {
        return true;
    }

    @Override
    protected ApplicationUser getReporter(Message message, MessageHandlerContext context) throws MessagingException {
        if (this.reporterUser == null) {
            this.reporterUser = this.getOrCreateReporter(message, context);
        }
        return this.reporterUser;
    }

    protected ApplicationUser getOrCreateReporter(Message message, MessageHandlerContext context) throws MessagingException {
        this.logger.debug((Object)".getOrCreateReporter() called");
        Project project = this.projectManager.getProjectObj(this.mailHandlerContext.getProjectId());
        if (project == null) {
            return null;
        }
        ApplicationUser applicationUserReporter = this.getMessageUserProcessor().getAuthorFromSender(message);
        this.logger.debug((Object)("Reporter User: " + applicationUserReporter));
        if (applicationUserReporter == null) {
            this.logger.debug((Object)("Report User not found, is SD open for public signup? " + this.serviceDesk.isOpenForPublicSignup()));
            if (this.serviceDesk.isOpenForPublicSignup()) {
                applicationUserReporter = this.createServiceDeskCustomer(message);
                this.logger.debug((Object)("New customer created: " + applicationUserReporter));
            }
            if (applicationUserReporter == null && this.reporteruserName != null) {
                applicationUserReporter = UserUtils.getUser((String)this.reporteruserName);
                this.logger.debug((Object)("Using default reporter: " + applicationUserReporter));
            }
        } else {
            boolean reporterHasPermission = project != null && this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, applicationUserReporter, true);
            this.logger.debug((Object)("Reporter has permission to create issue: " + reporterHasPermission));
            if (!reporterHasPermission && !this.serviceDeskManager.userHasPortalAccess(applicationUserReporter, project, this.serviceDesk) && this.reporteruserName != null) {
                applicationUserReporter = UserUtils.getUser((String)this.reporteruserName);
                this.logger.debug((Object)("Using default reporter: " + applicationUserReporter));
            }
        }
        return applicationUserReporter;
    }

    private ApplicationUser createServiceDeskCustomer(Message message) {
        this.logger.debug((Object)".createServiceDeskCustomer() called");
        ApplicationUser customerCreated = null;
        try {
            HashSet<String> senders = MailUtil.getSendersInLowerCase(message);
            if (!senders.isEmpty()) {
                String senderEmailAddress = (String)senders.iterator().next();
                customerCreated = this.serviceDeskManager.createNewCustomer(senderEmailAddress, this.mailHandlerContext.getProjectId(), this.mailHandlerContext.getCustomerCreatedTemplateId());
                this.logger.debug((Object)("new customer created: " + customerCreated));
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return customerCreated;
    }
}

