/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.jira.bc.issue.comment.property.CommentPropertyHelper;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskDetails;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.handler.AbstractMailHandler;
import com.metainf.jira.plugin.emailissue.handler.AbstractMessageHandler;
import com.metainf.jira.plugin.emailissue.handler.IssueSupportingMessageHandlerContext;
import com.metainf.jira.plugin.emailissue.handler.JETIMailHandler;
import com.metainf.jira.plugin.emailissue.handler.MailUtil;
import com.metainf.jira.plugin.emailissue.handler.RegexSupportingCreateOrCommentHandler;
import com.metainf.jira.plugin.emailissue.handler.ReporterResolvingCreateOrCommentHandler;
import com.metainf.jira.plugin.emailissue.util.CollectionUtils;
import com.metainf.jira.plugin.emailissue.workflow.IssueTransitioner;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ServiceDeskCommentHandler
extends AbstractMailHandler
implements JETIMailHandler {
    private static transient Logger logger = Logger.getLogger(ServiceDeskCommentHandler.class);
    private String[] splitRegexps;
    private final AutoReplyParams mailHandlerContext;
    private final AutoReplyParams.ProcessingType processingType;
    private final PermissionManager permissionManager;
    private final IssueManager issueManager;
    private final ProjectManager projectManager;
    private final FieldContextProcessor fieldContextProcessor;
    private final ServiceDeskManager serviceDeskManager;
    private final CustomFieldManager customFieldManager;
    private final IssueTransitioner issueTransitioner;
    private final Project projectForHandler;
    private final Issue issueAffectedByMessage;
    private ApplicationUser commentAuthor;
    private ServiceDeskDetails serviceDesk;

    protected ServiceDeskCommentHandler(Issue issueAffectedByMessage, AutoReplyParams mailHandlerContext, FieldContextProcessor fieldContextProcessor, ServiceDeskManager serviceDeskManager, CustomFieldManager customFieldManager, IssueTransitioner issueTransitioner, IssueManager issueManager) {
        super(mailHandlerContext, fieldContextProcessor);
        this.issueAffectedByMessage = issueAffectedByMessage;
        this.customFieldManager = customFieldManager;
        this.serviceDeskManager = serviceDeskManager;
        this.mailHandlerContext = mailHandlerContext;
        this.splitRegexps = StringUtils.isNotBlank((String)mailHandlerContext.getSplitregex()) ? mailHandlerContext.getSplitregex().split("\r\n") : null;
        this.fieldContextProcessor = fieldContextProcessor;
        this.permissionManager = ComponentAccessor.getPermissionManager();
        this.projectManager = ComponentAccessor.getProjectManager();
        this.issueManager = issueManager;
        this.issueTransitioner = issueTransitioner;
        this.processingType = mailHandlerContext.getProcessingStrategy() == null ? AutoReplyParams.ProcessingType.CREATE_OR_COMMENT : mailHandlerContext.getProcessingStrategy();
        this.projectForHandler = mailHandlerContext.getProjectId() == null ? null : this.projectManager.getProjectObj(mailHandlerContext.getProjectId());
    }

    @Override
    public void init(Map<String, String> params, MessageHandlerErrorCollector errorCollector) {
        super.init(params, errorCollector);
    }

    @Override
    protected boolean handleMessage(Message message, IssueSupportingMessageHandlerContext messageHandlerContext, Issue issue) throws MessagingException {
        boolean internalComment;
        boolean hasPermissionToComment;
        boolean emailProcessed = false;
        logger.debug((Object)(".handleMessage() called for issue: " + issue));
        this.serviceDesk = this.serviceDeskManager.getServiceDeskDetails(issue.getProjectId());
        logger.debug((Object)("Service Desk Details: " + this.serviceDesk));
        ApplicationUser senderUser = this.getMessageUserProcessor().getAuthorFromSender(message);
        boolean isSenderCustomerAndReporterOrRequestParticipant = senderUser != null && (this.serviceDeskManager.isUserCustomerAndReporter(senderUser, issue, this.serviceDesk) || this.serviceDeskManager.isUserParticipantAndParticipantsEnabled(senderUser, issue, this.serviceDesk));
        boolean isSenderAgent = senderUser != null && this.serviceDeskManager.isUserAgent(senderUser, issue.getProjectObject());
        logger.info((Object)("Sender: " + senderUser + ", is agent: " + isSenderAgent + ", is customer/reporter or participant: " + isSenderCustomerAndReporterOrRequestParticipant));
        boolean bl = hasPermissionToComment = senderUser != null && this.hasPermissionToComment(senderUser, issue);
        if (senderUser != null && (hasPermissionToComment || isSenderCustomerAndReporterOrRequestParticipant)) {
            this.commentAuthor = senderUser;
            logger.debug((Object)("reporter has permissions, " + this.commentAuthor));
        } else {
            this.commentAuthor = this.getDefaultReporterUser();
            logger.debug((Object)("Using default reporter, " + this.commentAuthor));
        }
        boolean bl2 = internalComment = !isSenderAgent && !isSenderCustomerAndReporterOrRequestParticipant;
        if (AutoReplyParams.ServiceDeskCommentVisibility.INTERNAL.equals((Object)this.mailHandlerContext.getSdCommentVisibility())) {
            internalComment = true;
        } else if (AutoReplyParams.ServiceDeskCommentVisibility.PUBLIC.equals((Object)this.mailHandlerContext.getSdCommentVisibility())) {
            internalComment = false;
        }
        logger.debug((Object)("New comment will be internal? " + internalComment));
        try {
            messageHandlerContext.addCommentProperty("sd.comment.property", "sd.public.comment", new JSONObject().put("internal", internalComment));
            messageHandlerContext.addCommentProperty(((CommentPropertyHelper)ComponentAccessor.getComponent(CommentPropertyHelper.class)).getEntityPropertyType().getDbEntityName(), "sd.public.comment", new JSONObject().put("internal", internalComment));
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.addParticipants(message, issue, this.serviceDesk, this.commentAuthor != null ? this.commentAuthor : issue.getReporterUser());
        MessageHandler handler = this.getHandler();
        logger.debug((Object)("Handler to create comment: " + handler));
        emailProcessed = handler.handleMessage(message, (MessageHandlerContext)messageHandlerContext);
        logger.debug((Object)("Email processed by handler: " + emailProcessed));
        if (emailProcessed && senderUser != null && messageHandlerContext.getCommentAdded() != null) {
            this.serviceDeskManager.makeCommentInternalOrPublic(messageHandlerContext.getCommentAdded(), senderUser, internalComment);
            if (!messageHandlerContext.getAttachmentNames().isEmpty() && !internalComment) {
                StringBuilder attachmentLinks = new StringBuilder("\n\r\n\r");
                for (String attachmentName : messageHandlerContext.getAttachmentNames()) {
                    attachmentLinks.append("[^").append(attachmentName).append("]\n\r\n\r");
                }
                CommentManager commentManager = ComponentAccessor.getCommentManager();
                MutableComment comment = commentManager.getMutableComment(messageHandlerContext.getCommentAdded().getId());
                comment.setBody(comment.getBody() + attachmentLinks.toString());
                commentManager.update((Comment)comment, false);
            }
            if (!hasPermissionToComment && isSenderCustomerAndReporterOrRequestParticipant) {
                this.issueTransitioner.transitionIssue(messageHandlerContext.getIssueAffected(), "sd.action.key", "sdWFCustomerToWFSupport", this.getDefaultReporterUser());
            } else if (hasPermissionToComment && isSenderAgent) {
                this.issueTransitioner.transitionIssue(messageHandlerContext.getIssueAffected(), "sd.action.key", "sdWFSupportToWFCustomer", this.getDefaultReporterUser());
            }
        }
        if (senderUser == null && this.serviceDesk.isOpenForPublicSignup()) {
            logger.debug((Object)"Public signup, creating new customer");
            ApplicationUser newCustomer = this.createServiceDeskCustomerForSender(message);
            logger.debug((Object)("New customer created: " + newCustomer));
        }
        return emailProcessed;
    }

    private ApplicationUser createServiceDeskCustomerForSender(Message message) {
        ApplicationUser customerCreated = null;
        try {
            HashSet<String> senders = MailUtil.getSendersInLowerCase(message);
            if (!senders.isEmpty()) {
                String senderEmailAddress = (String)senders.iterator().next();
                customerCreated = this.serviceDeskManager.createNewCustomer(senderEmailAddress, this.mailHandlerContext.getProjectId(), this.mailHandlerContext.getCustomerCreatedTemplateId());
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return customerCreated;
    }

    private void addParticipants(Message message, Issue issue, ServiceDeskDetails serviceDesk, ApplicationUser actingUser) {
        if (issue instanceof MutableIssue) {
            HashSet<String> allRecipientEmailAddresses = MailUtil.getEmailAddresses(message, MimeMessage.RecipientType.TO, MimeMessage.RecipientType.CC);
            HashSet<String> excludeEmails = StringUtils.isNotBlank((String)this.mailHandlerContext.getExcludeEmailsRegex()) ? new HashSet<String>(Arrays.asList(this.mailHandlerContext.getExcludeEmailsRegex().toLowerCase().split("\r\n"))) : new HashSet();
            CollectionUtils.removeAllIgnoreCase(allRecipientEmailAddresses, (Collection<String>)excludeEmails);
            MutableIssue mutableIssue = issue instanceof MutableIssue ? (MutableIssue)issue : this.issueManager.getIssueObject(issue.getId());
            Collection<ApplicationUser> participantsAddedToIssue = this.serviceDeskManager.addParticipantsInIssue(mutableIssue, serviceDesk, allRecipientEmailAddresses, actingUser, this.mailHandlerContext.getCustomerCreatedTemplateId());
            if (participantsAddedToIssue != null && !participantsAddedToIssue.isEmpty()) {
                this.issueManager.updateIssue(actingUser, mutableIssue, EventDispatchOption.DO_NOT_DISPATCH, false);
                this.serviceDeskManager.sendParticipantAddedEmail(issue, serviceDesk, participantsAddedToIssue, actingUser, this.mailHandlerContext.getParticipantAddedTemplateId());
            }
        }
    }

    @Override
    protected Issue lookupIssueUponFieldRules(Message message) throws MessagingException {
        return this.issueAffectedByMessage;
    }

    private boolean hasPermissionToComment(ApplicationUser senderUser, Issue issue) {
        boolean has = this.permissionManager.hasPermission(ProjectPermissions.ADD_COMMENTS, issue, senderUser);
        return has;
    }

    private MessageHandler getHandler() {
        AbstractMessageHandler handler = null;
        handler = this.splitRegexps != null && this.splitRegexps.length > 0 ? new RegexSupportingCreateOrCommentHandler(this.splitRegexps, this.mailHandlerContext, this.fieldContextProcessor){

            @Override
            protected boolean reporterHasCommentIssuePermission(Issue issue, ApplicationUser reporterUser) {
                return true;
            }

            @Override
            protected Issue getAssociatedIssue(Message message) {
                return ServiceDeskCommentHandler.this.issueAffectedByMessage;
            }

            @Override
            protected ApplicationUser getReporter(Message message, MessageHandlerContext context) throws MessagingException {
                return ServiceDeskCommentHandler.this.commentAuthor != null ? ServiceDeskCommentHandler.this.commentAuthor : super.getReporter(message, context);
            }
        } : new ReporterResolvingCreateOrCommentHandler(this.fieldContextProcessor, this.mailHandlerContext){

            @Override
            protected boolean reporterHasCommentIssuePermission(Issue issue, ApplicationUser reporterUser) {
                return true;
            }

            @Override
            protected Issue getAssociatedIssue(Message message) {
                return ServiceDeskCommentHandler.this.issueAffectedByMessage;
            }

            @Override
            protected ApplicationUser getReporter(Message message, MessageHandlerContext context) throws MessagingException {
                return ServiceDeskCommentHandler.this.commentAuthor != null ? ServiceDeskCommentHandler.this.commentAuthor : super.getReporter(message, context);
            }
        };
        handler.init(this.params, this.errorCollector);
        return handler;
    }
}

