/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.mail.HtmlToTextConverter;
import com.atlassian.mail.MailUtils;
import com.google.common.base.Strings;
import com.metainf.jira.plugin.emailissue.template.Renderer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;
import org.w3c.tidy.Tidy;

public class RichTextMailUtils {
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    static final int BUFFER_SIZE = 65536;
    static final String MULTIPART_ALTERNATE_CONTENT_TYPE = "multipart/alternative";
    static final String MULTIPART_RELATED_CONTENT_TYPE = "multipart/related";
    static final String TEXT_CONTENT_TYPE = "text/plain";
    static final String MESSAGE_CONTENT_TYPE = "message/rfc822";
    static final String HTML_CONTENT_TYPE = "text/html";
    static final String CONTENT_TYPE_X_PKCS7 = "application/x-pkcs7-signature";
    static final String CONTENT_TYPE_PKCS7 = "application/pkcs7-signature";
    private static final HtmlToTextConverter htmlConverter = new HtmlToTextConverter();
    private static final Logger log = Logger.getLogger(RichTextMailUtils.class);
    private static final String CONTENT_TRANSFER_ENCODING_HEADER = "Content-Transfer-Encoding";
    private static final String CONTENT_ID_HEADER = "Content-ID";

    public static String stripContentID(Part part) throws MessagingException {
        String cid;
        String string = cid = part instanceof MimeBodyPart ? ((MimeBodyPart)part).getContentID() : "CID";
        if (!Strings.isNullOrEmpty((String)cid)) {
            int indArrow = cid.indexOf("<");
            int indDog = cid.indexOf("@");
            if (indArrow != -1 && indDog != -1) {
                cid = cid.substring(indArrow + 1, indDog);
            }
        }
        return cid;
    }

    public static String getFileNameFromContentID(Part part) throws MessagingException {
        String fileName = null;
        String file = part.getFileName();
        if (Strings.isNullOrEmpty((String)file)) {
            String ss = ((MimeBodyPart)part).getContentID();
            if (!Strings.isNullOrEmpty((String)ss)) {
                int indArrow = ss.indexOf("<");
                int indDog = ss.indexOf("@");
                if (indArrow != -1 && indDog != -1) {
                    fileName = ss.substring(indArrow + 1, indDog);
                }
            }
        } else {
            fileName = file;
        }
        return fileName;
    }

    private static String fixImgSrc(String body, Long issueId, Message message) throws IOException, MessagingException {
        ApplicationProperties ap = ComponentAccessor.getApplicationProperties();
        String token = "src=\"cid:";
        String baseUrl = ap.getString("jira.baseurl");
        StringBuilder str = new StringBuilder(body);
        int index = str.indexOf(token);
        while (index != -1) {
            int startSrc = str.indexOf("\"", index) + 1;
            int startCid = str.indexOf(":", startSrc) + 1;
            int endSrc = str.indexOf("\"", startSrc);
            String cid = str.substring(startCid, endSrc);
            Object messageContent = message.getContent();
            Part attachment = null;
            if (messageContent instanceof Multipart) {
                attachment = RichTextMailUtils.getPartByContentID(cid, (Multipart)messageContent);
                if (attachment == null) {
                    log.warn((Object)("Can't find attach for cid = " + cid + ". Ignore this image."));
                    index = str.indexOf(token, endSrc);
                    continue;
                }
                String filename = RichTextMailUtils.getFileNameFromContentID(attachment);
                String mimeType = attachment.getContentType().split(";")[0];
                filename = RichTextMailUtils.buildAttachmentName(filename, cid);
                String replaceStr = baseUrl + "/plugins/servlet/jeditor_attached_image_provider?attachName=" + filename + "&issueId=" + issueId + "&thumb=false&mime=" + (mimeType != null ? mimeType.toLowerCase() : "");
                str.replace(startSrc, endSrc, replaceStr);
                index = str.indexOf(token, index + replaceStr.length());
                continue;
            }
            index = str.indexOf(token, endSrc);
        }
        return str.toString();
    }

    public static String base64Img(String base64, String cid, String contentType, String body) {
        if (StringUtils.isNotBlank((String)body)) {
            body = body.replaceAll("src=\"cid:" + cid + "\"", "src=\"data:" + contentType + ";base64," + base64 + "\"");
        }
        return body;
    }

    public static String buildAttachmentName(String fileName, String cid) {
        String suffix;
        fileName = fileName == null ? "" : fileName;
        String string = suffix = cid == null ? "" : cid.replaceAll("<", "").replaceAll(">", "").replaceAll("@", "");
        if (suffix.startsWith(fileName)) {
            suffix = suffix.substring(fileName.length()).replaceAll("\\.", "");
            int dot = fileName.lastIndexOf(".");
            fileName = dot > 0 ? fileName.substring(0, dot) + "_" + suffix + fileName.substring(dot) : fileName + "_" + suffix;
        }
        return fileName;
    }

    private static void getCid(Multipart multipart, Map<String, String> fileNameCidMap) throws MessagingException, IOException {
        int parts = multipart.getCount();
        for (int i = 0; i < parts; ++i) {
            MimeBodyPart mimePart;
            String partID;
            BodyPart part = multipart.getBodyPart(i);
            Object partContent = part.getContent();
            if (partContent instanceof Multipart) {
                RichTextMailUtils.getCid((Multipart)partContent, fileNameCidMap);
                continue;
            }
            if (!(part instanceof MimeBodyPart) || Strings.isNullOrEmpty((String)(partID = (mimePart = (MimeBodyPart)part).getContentID()))) continue;
            String cid = partID.replaceAll("<", "").replaceAll(">", "");
            String fn = RichTextMailUtils.getFileNameFromContentID((Part)mimePart);
            if (!StringUtils.isNotBlank((String)fn)) continue;
            fileNameCidMap.put(fn, cid);
        }
    }

    public static Map<String, String> getFilenamesWithCid(Message message) throws IOException, MessagingException {
        HashMap<String, String> map = new HashMap<String, String>();
        Object messageContent = message.getContent();
        Object attachment = null;
        if (messageContent instanceof Multipart) {
            RichTextMailUtils.getCid((Multipart)messageContent, map);
        }
        return map;
    }

    public static Part getPartByContentID(String id, Multipart multipart) throws MessagingException, IOException {
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            MimeBodyPart mimePart;
            String partID;
            BodyPart part = multipart.getBodyPart(i);
            Object partContent = part.getContent();
            if (partContent instanceof Multipart) {
                Part foundedpart = RichTextMailUtils.getPartByContentID(id, (Multipart)partContent);
                if (foundedpart == null) continue;
                return foundedpart;
            }
            if (!(part instanceof MimeBodyPart) || Strings.isNullOrEmpty((String)(partID = (mimePart = (MimeBodyPart)part).getContentID())) || !partID.replaceAll("<", "").replaceAll(">", "").equalsIgnoreCase(id)) continue;
            return mimePart;
        }
        return null;
    }

    public static String getRichTextContent(Issue issue, Message message, Renderer fieldRenderer) throws MessagingException {
        try {
            String content = RichTextMailUtils.extractTextFromPart((Part)message);
            if (content == null && message.getContent() instanceof Multipart) {
                content = RichTextMailUtils.getBodyFromMultipart((Multipart)message.getContent());
            }
            if (content == null) {
                log.info((Object)"Could not find any body to extract from the message");
            }
            if (StringUtils.isNotBlank((String)content)) {
                content = content.replaceAll("(?si)<base.*?>", "").replaceAll("(?si)</?html[^>]*?>", "").replaceAll("(?si)</?body[^>]*?>", "").replaceAll("(?si)</?head[^>]*?>", "").replaceAll("(?si)<meta[^>]*?>", "").replaceAll("(?si)<xml.*?</xml>", "").replaceAll("(?si)</?o:[^>]*?>", "").replaceAll("(?si)</?u1:[^>]*?>", "").replaceAll("(?si)<p[^>]*?>[\r\n\t ]*?</p>", "").replaceAll("(?si)[\r\n\t]*?<", "<");
                if (fieldRenderer == Renderer.JEDITOR) {
                    content = RichTextMailUtils.fixImgSrc(content, issue.getId(), message);
                }
            }
            return "<div>" + content + "</div>";
        }
        catch (ClassCastException cce) {
            log.info((Object)("Exception getting the content type of message - probably not of type 'String': " + cce.getMessage()));
            return null;
        }
        catch (IOException e) {
            log.info((Object)("IOException whilst getting message content " + e.getMessage()));
            return null;
        }
    }

    public static MailUtils.Attachment[] getAttachments(Message message) throws MessagingException, IOException {
        ArrayList<MailUtils.Attachment> attachments = new ArrayList<MailUtils.Attachment>();
        if (message.getContent() instanceof Multipart) {
            RichTextMailUtils.addAttachments(attachments, (Multipart)message.getContent());
        }
        return attachments.toArray(new MailUtils.Attachment[attachments.size()]);
    }

    private static void addAttachments(List<MailUtils.Attachment> attachments, Multipart parts) throws MessagingException, IOException {
        int n = parts.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part = parts.getBodyPart(i);
            if (RichTextMailUtils.isAttachment(part)) {
                InputStream content = part.getInputStream();
                String contentType = part.getContentType();
                attachments.add(new MailUtils.Attachment(contentType, RichTextMailUtils.getFileNameFromContentID((Part)part), RichTextMailUtils.toByteArray(content)));
                continue;
            }
            try {
                if (!(part.getContent() instanceof Multipart)) continue;
                RichTextMailUtils.addAttachments(attachments, (Multipart)part.getContent());
                continue;
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Object)"Unsupported encoding found for part while trying to discover attachments. Attachment will be ignored.", (Throwable)e);
            }
        }
    }

    private static boolean isAttachment(BodyPart part) throws MessagingException {
        return "attachment".equals(part.getDisposition()) || "inline".equals(part.getDisposition()) || part.getDisposition() == null && RichTextMailUtils.getFileNameFromContentID((Part)part) != null;
    }

    private static byte[] toByteArray(InputStream in) throws IOException {
        int count;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        while ((count = in.read(buf)) != -1) {
            out.write(buf, 0, count);
        }
        out.close();
        return out.toByteArray();
    }

    private static String extractFilenameFromPath(String path) {
        String fileName;
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, "\\/");
        do {
            fileName = st.nextToken();
        } while (st.hasMoreTokens());
        return fileName;
    }

    public static MimeBodyPart createZippedAttachmentMimeBodyPart(String path) throws MessagingException {
        File tmpFile = null;
        String fileName = RichTextMailUtils.extractFilenameFromPath(path);
        try {
            tmpFile = File.createTempFile("atlassian", null);
            FileOutputStream fout = new FileOutputStream(tmpFile);
            ZipOutputStream zout = new ZipOutputStream(fout);
            zout.putNextEntry(new ZipEntry(fileName));
            FileInputStream in = new FileInputStream(path);
            byte[] buffer = new byte[65536];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buffer))) {
                zout.write(buffer, 0, n);
            }
            zout.close();
            ((InputStream)in).close();
            log.debug((Object)("Wrote temporary zip of attachment to " + tmpFile));
        }
        catch (FileNotFoundException e) {
            String err = "Couldn't find file '" + path + "' on server: " + e;
            log.error((Object)err, (Throwable)e);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(err);
            return mimeBodyPart;
        }
        catch (IOException e) {
            String err = "Error zipping log file '" + path + "' on server: " + e;
            log.error((Object)err, (Throwable)e);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(err);
            return mimeBodyPart;
        }
        MimeBodyPart attachmentPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(tmpFile);
        attachmentPart.setDataHandler(new DataHandler((DataSource)source));
        attachmentPart.setFileName(fileName + ".zip");
        attachmentPart.setHeader("Content-Type", "application/zip");
        return attachmentPart;
    }

    private static String getBodyFromMultipart(Multipart multipart) throws MessagingException, IOException {
        StringBuffer sb = new StringBuffer();
        RichTextMailUtils.getBodyFromMultipart(multipart, sb);
        return sb.toString();
    }

    private static void getBodyFromMultipart(Multipart multipart, StringBuffer sb) throws MessagingException, IOException {
        String multipartType = multipart.getContentType();
        if (multipartType != null && RichTextMailUtils.compareContentType(multipartType, MULTIPART_ALTERNATE_CONTENT_TYPE)) {
            BodyPart part = RichTextMailUtils.getFirstInlinePartWithMimeType(multipart, HTML_CONTENT_TYPE);
            if (part != null) {
                RichTextMailUtils.appendMultipartText(RichTextMailUtils.extractTextFromPart((Part)part), sb);
            } else {
                part = RichTextMailUtils.getFirstInlinePartWithMimeType(multipart, TEXT_CONTENT_TYPE);
                if (part != null) {
                    RichTextMailUtils.appendMultipartText(RichTextMailUtils.extractTextFromPart((Part)part), sb);
                }
            }
            return;
        }
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            String contentType = part.getContentType();
            if ("attachment".equals(part.getDisposition()) || contentType == null) continue;
            try {
                String content = RichTextMailUtils.extractTextFromPart((Part)part);
                if (content != null) {
                    RichTextMailUtils.appendMultipartText(content, sb);
                    continue;
                }
                if (!(part.getContent() instanceof Multipart)) continue;
                RichTextMailUtils.getBodyFromMultipart((Multipart)part.getContent(), sb);
                continue;
            }
            catch (IOException exception) {
                log.warn((Object)("Error retrieving content from part '" + exception.getMessage() + "'"), (Throwable)exception);
            }
        }
    }

    private static void appendMultipartText(String content, StringBuffer sb) throws IOException, MessagingException {
        if (content != null) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(content);
        }
    }

    private static String extractTextFromPart(Part part) throws IOException, MessagingException, UnsupportedEncodingException {
        if (part == null) {
            return null;
        }
        String content = null;
        if (RichTextMailUtils.isPartPlainText(part)) {
            try {
                content = (String)part.getContent();
                content = content == null ? null : content.replaceAll("\n", "<br>");
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Object)("Found unsupported encoding '" + e.getMessage() + "'. Reading content with " + DEFAULT_ENCODING + " encoding."));
                content = RichTextMailUtils.getBody(part, DEFAULT_ENCODING);
            }
        } else if (RichTextMailUtils.isPartHtml(part)) {
            content = (String)part.getContent();
        }
        if (content == null) {
            log.warn((Object)("Unable to extract text from MIME part with Content-Type '" + part.getContentType()));
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBody(Part part, String charsetName) throws UnsupportedEncodingException, IOException, MessagingException {
        String string;
        BufferedReader input = null;
        StringWriter output = null;
        try {
            input = new BufferedReader(new InputStreamReader(part.getInputStream(), charsetName));
            output = new StringWriter();
            IOUtils.copy((Reader)input, (Writer)output);
            string = output.getBuffer().toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)input);
        IOUtils.closeQuietly((Writer)output);
        return string;
    }

    private static BodyPart getFirstInlinePartWithMimeType(Multipart multipart, String mimeType) throws MessagingException, IOException {
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            String contentType = part.getContentType();
            if (contentType.contains("multipart") && part.getContent() instanceof MimeMultipart) {
                return RichTextMailUtils.getFirstInlinePartWithMimeType((Multipart)((MimeMultipart)part.getContent()), mimeType);
            }
            if ("attachment".equals(part.getDisposition()) || contentType == null || !RichTextMailUtils.compareContentType(contentType, mimeType)) continue;
            return part;
        }
        return null;
    }

    private static boolean compareContentType(String contentType, String mimeType) {
        return contentType.toLowerCase().startsWith(mimeType);
    }

    public static boolean isPartHtml(Part part) throws MessagingException {
        String contentType = RichTextMailUtils.getContentType(part);
        return HTML_CONTENT_TYPE.equalsIgnoreCase(contentType);
    }

    public static boolean isPartPlainText(Part part) throws MessagingException {
        String contentType = RichTextMailUtils.getContentType(part);
        return TEXT_CONTENT_TYPE.equalsIgnoreCase(contentType);
    }

    public static String getContentType(Part part) throws MessagingException {
        RichTextMailUtils.checkPartNotNull(part);
        String contentType = part.getContentType();
        return RichTextMailUtils.getContentType(contentType);
    }

    public static String getContentType(String headerValue) {
        RichTextMailUtils.checkHeaderValue(headerValue);
        String out = headerValue;
        int semiColon = headerValue.indexOf(59);
        if (-1 != semiColon) {
            out = headerValue.substring(0, semiColon);
        }
        return out.trim();
    }

    private static void checkHeaderValue(String headerValue) {
        Validate.notEmpty((String)headerValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isContentEmpty(Part part) throws MessagingException, IOException {
        RichTextMailUtils.checkPartNotNull(part);
        boolean definitelyEmpty = false;
        Object content = part.getContent();
        if (null == content) {
            definitelyEmpty = true;
        } else {
            if (content instanceof String) {
                String stringContent = (String)content;
                definitelyEmpty = StringUtils.isBlank((String)stringContent);
            }
            if (content instanceof InputStream) {
                InputStream inputStream = (InputStream)content;
                try {
                    int firstByte = inputStream.read();
                    definitelyEmpty = -1 == firstByte;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
        return definitelyEmpty;
    }

    private static void checkPartNotNull(Part part) {
        Validate.notNull((Object)part, (String)"part should not be null.");
    }

    public static String tidyHtml(String splitBody) {
        Tidy tidy = new Tidy();
        tidy.setPrintBodyOnly(true);
        tidy.setInputEncoding("UTF-8");
        tidy.setOutputEncoding("UTF-8");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            tidy.parse((InputStream)new ByteArrayInputStream(splitBody.getBytes("UTF-8")), (OutputStream)baos);
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return splitBody;
        }
    }

    public static String getRawBody(Message message) throws MessagingException {
        return MailUtils.getBody((Message)message);
    }

    public static boolean isRenderedAsRichText(Issue issue, String field) {
        FieldLayoutItem fli = ComponentAccessor.getFieldLayoutManager().getFieldLayout(issue).getFieldLayoutItem(field);
        return fli != null && Renderer.JEDITOR.getKey().equalsIgnoreCase(fli.getRendererType());
    }

    public static String splitMailBody(String rawBody, String[] splitRegexps, boolean richTextComment) {
        String splitBody = rawBody;
        if (splitRegexps != null && splitRegexps.length > 0) {
            ArrayList parts = new ArrayList();
            for (String splitRegex : splitRegexps) {
                try {
                    if (!StringUtils.isNotEmpty((String)splitRegex)) continue;
                    parts.clear();
                    new Perl5Util().split(parts, splitRegex, rawBody);
                    if (parts.isEmpty() || parts.size() <= 1) continue;
                    StringBuilder comment = new StringBuilder("\n");
                    comment.append(((String)parts.get(0)).trim());
                    comment.append("\n\n");
                    splitBody = comment.toString();
                    if (!richTextComment) break;
                    splitBody = RichTextMailUtils.tidyHtml(splitBody);
                    break;
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to split email body. Appending raw content...", (Throwable)e);
                }
            }
        }
        return splitBody;
    }
}

