/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.atlassian.jira.service.util.handler.MessageUserProcessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.mail.MailUtils;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.handler.CreateOrCommentHandler;
import com.metainf.jira.plugin.emailissue.handler.FullCommentHandler;
import com.metainf.jira.plugin.emailissue.handler.JETIMailHandler;
import com.metainf.jira.plugin.emailissue.handler.NonQuotedCommentHandler;
import com.metainf.jira.plugin.emailissue.handler.ReporterResolvingCreateIssueHandler;
import com.metainf.jira.plugin.emailissue.handler.RichTextMailUtils;
import com.metainf.jira.plugin.emailissue.mail.EmailBean;
import javax.mail.Message;
import javax.mail.MessagingException;

public class ReporterResolvingCreateOrCommentHandler
extends CreateOrCommentHandler
implements JETIMailHandler {
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final FieldContextProcessor fieldContextProcessor;
    private final AutoReplyParams mailHandlerContext;

    public ReporterResolvingCreateOrCommentHandler(FieldContextProcessor fieldContextProcessor, AutoReplyParams mailHandlerContext) {
        this.fieldContextProcessor = fieldContextProcessor;
        this.mailHandlerContext = mailHandlerContext;
        this.permissionManager = ComponentAccessor.getPermissionManager();
        this.projectManager = ComponentAccessor.getProjectManager();
    }

    @Override
    public boolean handleMessage(Message message, MessageHandlerContext context) throws MessagingException {
        Issue issue;
        String subject = message.getSubject();
        if (!this.canHandleMessage(message, context.getMonitor())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cannot handle message '" + subject + "'."));
            }
            return this.deleteEmail;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Looking for Issue Key in subject '" + subject + "'."));
        }
        if ((issue = this.getIssueFromMessage(message)) != null) {
            boolean doDelete;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Issue '" + issue.getKey() + "' found for email '" + subject + "'."));
            }
            if (this.stripquotes == null || "false".equalsIgnoreCase(this.stripquotes)) {
                FullCommentHandler fc = new FullCommentHandler(){

                    @Override
                    protected boolean reporterHasCommentIssuePermission(Issue issue, ApplicationUser reporterUser) {
                        return ReporterResolvingCreateOrCommentHandler.this.reporterHasCommentIssuePermission(issue, reporterUser);
                    }

                    @Override
                    protected ApplicationUser getReporter(Message message, MessageHandlerContext context) throws MessagingException {
                        return ReporterResolvingCreateOrCommentHandler.this.getReporter(message, context);
                    }

                    @Override
                    protected MessageUserProcessor getMessageUserProcessor() {
                        return ReporterResolvingCreateOrCommentHandler.this.getMessageUserProcessor();
                    }

                    @Override
                    protected String getEmailBody(Message message) throws MessagingException {
                        return ReporterResolvingCreateOrCommentHandler.this.getEmailBody(message);
                    }

                    @Override
                    protected Issue getAssociatedIssue(Message message) {
                        return ReporterResolvingCreateOrCommentHandler.this.getAssociatedIssue(message);
                    }
                };
                fc.init(this.params, (MessageHandlerErrorCollector)context.getMonitor());
                doDelete = fc.handleMessage(message, context);
            } else {
                NonQuotedCommentHandler nq = new NonQuotedCommentHandler(){

                    @Override
                    protected boolean reporterHasCommentIssuePermission(Issue issue, ApplicationUser reporterUser) {
                        return ReporterResolvingCreateOrCommentHandler.this.reporterHasCommentIssuePermission(issue, reporterUser);
                    }

                    @Override
                    protected ApplicationUser getReporter(Message message, MessageHandlerContext context) throws MessagingException {
                        return ReporterResolvingCreateOrCommentHandler.this.getReporter(message, context);
                    }

                    @Override
                    protected MessageUserProcessor getMessageUserProcessor() {
                        return ReporterResolvingCreateOrCommentHandler.this.getMessageUserProcessor();
                    }

                    @Override
                    protected String getEmailBody(Message message) throws MessagingException {
                        return ReporterResolvingCreateOrCommentHandler.this.getEmailBody(message);
                    }

                    @Override
                    protected Issue getAssociatedIssue(Message message) {
                        return ReporterResolvingCreateOrCommentHandler.this.getAssociatedIssue(message);
                    }
                };
                nq.init(this.params, (MessageHandlerErrorCollector)context.getMonitor());
                doDelete = nq.handleMessage(message, context);
            }
            return doDelete;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("No Issue found for email '" + subject + "' - creating a new Issue."));
        }
        ReporterResolvingCreateIssueHandler createIssueHandler = new ReporterResolvingCreateIssueHandler(this.fieldContextProcessor, this.mailHandlerContext){

            @Override
            protected MessageUserProcessor getMessageUserProcessor() {
                return ReporterResolvingCreateOrCommentHandler.this.getMessageUserProcessor();
            }
        };
        createIssueHandler.init(this.params, (MessageHandlerErrorCollector)context.getMonitor());
        return createIssueHandler.handleMessage(message, context);
    }

    protected String getEmailBody(Message message) throws MessagingException {
        return RichTextMailUtils.getRawBody(message);
    }

    @Override
    protected ApplicationUser getReporter(Message message, MessageHandlerContext context) throws MessagingException {
        ApplicationUser reporter = this.getMessageUserProcessor().getAuthorFromSender(message);
        if (reporter == null && this.createUsers && context != null) {
            reporter = this.createUserForReporter(message, context);
        }
        Issue issueFromEmail = this.getIssueFromMessage(message);
        ApplicationUser applicationUserReporter = reporter;
        if (this.reporteruserName != null && (reporter == null || issueFromEmail != null && !this.permissionManager.hasPermission(ProjectPermissions.ADD_COMMENTS, issueFromEmail, applicationUserReporter))) {
            this.log.info((Object)("Sender(s) " + MailUtils.getSenders((Message)message) + " not registered in JIRA or does not have permissions to create issues or comments. Using configured default reporter '" + this.reporteruserName + "'."));
            reporter = UserUtils.getUser((String)this.reporteruserName);
        }
        return reporter;
    }

    protected Issue getIssueFromMessage(Message message) throws MessagingException {
        Issue issue = null;
        String subject = message.getSubject();
        issue = ServiceUtils.findIssueObjectInString((String)subject);
        if (issue == null) {
            this.log.debug((Object)("Issue Key not found in subject '" + subject + "'. Inspecting the in-reply-to message ID."));
            issue = this.getAssociatedIssue(message);
        }
        return issue;
    }

    @Override
    protected Issue getAssociatedIssue(Message message) {
        Issue issue = super.getAssociatedIssue(message);
        try {
            if (issue == null && this.mailHandlerContext != null && Boolean.TRUE.equals(this.mailHandlerContext.getOverrideIssueLookup())) {
                ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
                if (user == null) {
                    ApplicationUser reporter = this.getMessageUserProcessor().getAuthorFromSender(message);
                    if (reporter == null && this.reporteruserName != null) {
                        reporter = UserUtils.getUser((String)this.reporteruserName);
                    }
                    user = reporter;
                }
                issue = this.fieldContextProcessor.lookupIssue(this.mailHandlerContext.getProjectId(), this.mailHandlerContext.getIssueTypeId(), new EmailBean(message), user);
            }
        }
        catch (MessagingException e) {
            issue = null;
        }
        return issue;
    }

    protected boolean reporterHasCommentIssuePermission(Issue issue, ApplicationUser reporterUser) {
        return this.permissionManager.hasPermission(ProjectPermissions.ADD_COMMENTS, issue, reporterUser);
    }
}

