/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.mail.MailUtils;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.handler.CreateIssueHandler;
import com.metainf.jira.plugin.emailissue.handler.JETIMailHandler;
import javax.mail.Message;
import javax.mail.MessagingException;

public class ReporterResolvingCreateIssueHandler
extends CreateIssueHandler
implements JETIMailHandler {
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final FieldContextProcessor fieldContextProcessor;
    private final AutoReplyParams mailHandlerContext;

    public ReporterResolvingCreateIssueHandler(FieldContextProcessor fieldContextProcessor, AutoReplyParams mailHandlerContext) {
        this.fieldContextProcessor = fieldContextProcessor;
        this.mailHandlerContext = mailHandlerContext;
        this.permissionManager = ComponentAccessor.getPermissionManager();
        this.projectManager = ComponentAccessor.getProjectManager();
    }

    @Override
    protected ApplicationUser getReporter(Message message, MessageHandlerContext context) throws MessagingException {
        boolean reporterHasPermission;
        ApplicationUser reporter = this.getMessageUserProcessor().getAuthorFromSender(message);
        if (reporter == null && this.createUsers) {
            reporter = this.createUserForReporter(message, context);
        }
        Project project = this.projectManager.getProjectObjByKey(this.projectKey);
        boolean bl = reporterHasPermission = reporter != null && (this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, reporter, true) || reporter.getDirectoryId() == -1L);
        if (!(reporter != null && reporterHasPermission || this.reporteruserName == null)) {
            this.log.info((Object)("Sender(s) " + MailUtils.getSenders((Message)message) + " not registered in JIRA. Using configured default reporter '" + this.reporteruserName + "'."));
            reporter = UserUtils.getUser((String)this.reporteruserName);
        }
        return reporter;
    }
}

