/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.mail.MailUtils;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.handler.JETIMailHandler;
import com.metainf.jira.plugin.emailissue.handler.RegexCommentHandler;
import com.metainf.jira.plugin.emailissue.handler.RichTextMailUtils;
import com.metainf.jira.plugin.emailissue.mail.EmailBean;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

public class RegexSupportingCreateOrCommentHandler
extends RegexCommentHandler
implements JETIMailHandler {
    private static transient Logger logger = Logger.getLogger(RegexSupportingCreateOrCommentHandler.class);
    private String[] splitRegexps;
    private final AutoReplyParams mailHandlerContext;
    private final AutoReplyParams.ProcessingType processingType;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final FieldContextProcessor fieldContextProcessor;

    protected RegexSupportingCreateOrCommentHandler(String[] splitRegexps, AutoReplyParams mailHandlerContext, FieldContextProcessor fieldContextProcessor) {
        this.mailHandlerContext = mailHandlerContext;
        this.splitRegexps = splitRegexps;
        this.fieldContextProcessor = fieldContextProcessor;
        this.permissionManager = ComponentAccessor.getPermissionManager();
        this.projectManager = ComponentAccessor.getProjectManager();
        this.processingType = mailHandlerContext.getProcessingStrategy() == null ? AutoReplyParams.ProcessingType.CREATE_OR_COMMENT : mailHandlerContext.getProcessingStrategy();
    }

    @Override
    public void init(Map<String, String> params, MessageHandlerErrorCollector errorCollector) {
        super.init(params, errorCollector);
    }

    @Override
    public boolean handleMessage(Message message, MessageHandlerContext context) throws MessagingException {
        if (!this.canHandleMessage(message, context.getMonitor())) {
            return this.deleteEmail;
        }
        Issue issue = this.getIssueFromMessage(message);
        if (issue == null) {
            return false;
        }
        return super.handleMessage(message, context);
    }

    private Issue getIssueFromMessage(Message message) throws MessagingException {
        Issue issue = null;
        String subject = message.getSubject();
        issue = ServiceUtils.findIssueObjectInString((String)subject);
        if (issue == null) {
            this.log.debug((Object)("Issue Key not found in subject '" + subject + "'. Inspecting the in-reply-to message ID."));
            issue = this.getAssociatedIssue(message);
        }
        return issue;
    }

    @Override
    protected Issue getAssociatedIssue(Message message) {
        Issue issue = super.getAssociatedIssue(message);
        try {
            if (issue == null && this.mailHandlerContext != null && Boolean.TRUE.equals(this.mailHandlerContext.getOverrideIssueLookup())) {
                ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
                if (user == null) {
                    ApplicationUser reporter = this.getMessageUserProcessor().getAuthorFromSender(message);
                    if (reporter == null && this.reporteruserName != null) {
                        reporter = UserUtils.getUser((String)this.reporteruserName);
                    }
                    user = reporter;
                }
                issue = this.fieldContextProcessor.lookupIssue(this.mailHandlerContext.getProjectId(), this.mailHandlerContext.getIssueTypeId(), new EmailBean(message), user);
            }
        }
        catch (MessagingException e) {
            issue = null;
        }
        return issue;
    }

    @Override
    public String splitMailBody(String rawBody) {
        return RichTextMailUtils.splitMailBody(rawBody, this.splitRegexps, false);
    }

    @Override
    protected ApplicationUser getReporter(Message message, MessageHandlerContext context) throws MessagingException {
        ApplicationUser reporter = this.getMessageUserProcessor().getAuthorFromSender(message);
        if (reporter == null && this.createUsers && context != null) {
            reporter = this.createUserForReporter(message, context);
        }
        Issue issueFromEmail = this.getIssueFromMessage(message);
        ApplicationUser applicationUserReporter = reporter;
        if (this.reporteruserName != null && (reporter == null || issueFromEmail != null && !this.permissionManager.hasPermission(ProjectPermissions.ADD_COMMENTS, issueFromEmail, applicationUserReporter))) {
            this.log.info((Object)("Sender(s) " + MailUtils.getSenders((Message)message) + " not registered in JIRA or does not have permissions to create issues or comments. Using configured default reporter '" + this.reporteruserName + "'."));
            reporter = UserUtils.getUser((String)this.reporteruserName);
        }
        return reporter;
    }
}

