/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.search.SearchTerm;
import org.apache.commons.lang.StringUtils;

public class MessageProxy
extends Message {
    private Message delegate;

    public MessageProxy(Message delegate) {
        this.delegate = delegate;
        this.fixHeaders(this.delegate);
    }

    private void fixHeaders(Message message) {
        this.fixHeader(message, "In-Reply-To");
        this.fixHeader(message, "References");
    }

    private void fixHeader(Message message, String headerName) {
        block3: {
            try {
                String[] headers;
                if (this.delegate == null || (headers = message.getHeader(headerName)) == null || headers.length <= 0) break block3;
                for (int i = 0; i < headers.length; ++i) {
                    if (headers[i] == null || !headers[i].contains("@Atlassian")) continue;
                    headers[i] = headers[i].replace("@Atlassian", "");
                    message.setHeader(headerName, headers[i]);
                    break;
                }
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    public Address[] getFrom() throws MessagingException {
        return this.delegate.getFrom();
    }

    public void setFrom() throws MessagingException {
        this.delegate.setFrom();
    }

    public void setFrom(Address address) throws MessagingException {
        this.delegate.setFrom(address);
    }

    public void addFrom(Address[] addresses) throws MessagingException {
        this.delegate.addFrom(addresses);
    }

    public Address[] getRecipients(Message.RecipientType recipientType) throws MessagingException {
        return this.delegate.getRecipients(recipientType);
    }

    public Address[] getAllRecipients() throws MessagingException {
        return this.delegate.getAllRecipients();
    }

    public void setRecipients(Message.RecipientType recipientType, Address[] addresses) throws MessagingException {
        this.delegate.setRecipients(recipientType, addresses);
    }

    public void setRecipient(Message.RecipientType type, Address address) throws MessagingException {
        this.delegate.setRecipient(type, address);
    }

    public void addRecipients(Message.RecipientType recipientType, Address[] addresses) throws MessagingException {
        this.delegate.addRecipients(recipientType, addresses);
    }

    public void addRecipient(Message.RecipientType type, Address address) throws MessagingException {
        this.delegate.addRecipient(type, address);
    }

    public Address[] getReplyTo() throws MessagingException {
        return this.delegate.getReplyTo();
    }

    public void setReplyTo(Address[] addresses) throws MessagingException {
        this.delegate.setReplyTo(addresses);
    }

    public String getSubject() throws MessagingException {
        return StringUtils.isBlank((String)this.delegate.getSubject()) ? "(no subject)" : this.delegate.getSubject();
    }

    public void setSubject(String s) throws MessagingException {
        this.delegate.setSubject(s);
    }

    public Date getSentDate() throws MessagingException {
        return this.delegate.getSentDate();
    }

    public void setSentDate(Date date) throws MessagingException {
        this.delegate.setSentDate(date);
    }

    public Date getReceivedDate() throws MessagingException {
        return this.delegate.getReceivedDate();
    }

    public Flags getFlags() throws MessagingException {
        return this.delegate.getFlags();
    }

    public boolean isSet(Flags.Flag flag) throws MessagingException {
        return this.delegate.isSet(flag);
    }

    public void setFlags(Flags flags, boolean b) throws MessagingException {
        this.delegate.setFlags(flags, b);
    }

    public void setFlag(Flags.Flag flag, boolean set) throws MessagingException {
        this.delegate.setFlag(flag, set);
    }

    public int getMessageNumber() {
        return this.delegate.getMessageNumber();
    }

    public Folder getFolder() {
        return this.delegate.getFolder();
    }

    public boolean isExpunged() {
        return this.delegate.isExpunged();
    }

    public Message reply(boolean b) throws MessagingException {
        return this.delegate.reply(b);
    }

    public void saveChanges() throws MessagingException {
        this.delegate.saveChanges();
    }

    public boolean match(SearchTerm term) throws MessagingException {
        return this.delegate.match(term);
    }

    public int getSize() throws MessagingException {
        return this.delegate.getSize();
    }

    public int getLineCount() throws MessagingException {
        return this.delegate.getLineCount();
    }

    public String getContentType() throws MessagingException {
        return this.delegate.getContentType();
    }

    public boolean isMimeType(String s) throws MessagingException {
        return this.delegate.isMimeType(s);
    }

    public String getDisposition() throws MessagingException {
        return this.delegate.getDisposition();
    }

    public void setDisposition(String s) throws MessagingException {
        this.delegate.setDisposition(s);
    }

    public String getDescription() throws MessagingException {
        return this.delegate.getDescription();
    }

    public void setDescription(String s) throws MessagingException {
        this.delegate.setDescription(s);
    }

    public String getFileName() throws MessagingException {
        return this.delegate.getFileName();
    }

    public void setFileName(String s) throws MessagingException {
        this.delegate.setFileName(s);
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return this.delegate.getInputStream();
    }

    public DataHandler getDataHandler() throws MessagingException {
        return this.delegate.getDataHandler();
    }

    public Object getContent() throws IOException, MessagingException {
        return this.delegate.getContent();
    }

    public void setDataHandler(DataHandler dataHandler) throws MessagingException {
        this.delegate.setDataHandler(dataHandler);
    }

    public void setContent(Object o, String s) throws MessagingException {
        this.delegate.setContent(o, s);
    }

    public void setText(String s) throws MessagingException {
        this.delegate.setText(s);
    }

    public void setContent(Multipart multipart) throws MessagingException {
        this.delegate.setContent(multipart);
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        this.delegate.writeTo(outputStream);
    }

    public String[] getHeader(String s) throws MessagingException {
        return this.delegate.getHeader(s);
    }

    public void setHeader(String s, String s2) throws MessagingException {
        this.delegate.setHeader(s, s2);
    }

    public void addHeader(String s, String s2) throws MessagingException {
        this.delegate.addHeader(s, s2);
    }

    public void removeHeader(String s) throws MessagingException {
        this.delegate.removeHeader(s);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.delegate.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] strings) throws MessagingException {
        return this.delegate.getMatchingHeaders(strings);
    }

    public Enumeration getNonMatchingHeaders(String[] strings) throws MessagingException {
        return this.delegate.getNonMatchingHeaders(strings);
    }
}

