/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.mail.MailUtils;
import com.metainf.jira.plugin.emailissue.action.config.EmailField;
import com.metainf.jira.plugin.emailissue.converters.ImageInfo;
import com.metainf.jira.plugin.emailissue.converters.wiki.Attachment;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MailUtil {
    private static Logger logger = Logger.getLogger(MailUtil.class);

    public static HashSet<String> getSendersInLowerCase(Message message) throws MessagingException {
        boolean hasReplyTo;
        HashSet<String> senders = new HashSet<String>();
        Address[] replyTo = message.getReplyTo();
        boolean bl = hasReplyTo = replyTo != null && replyTo.length > 0;
        if (hasReplyTo) {
            for (Address a : replyTo) {
                String emailAddress;
                if (!(a instanceof InternetAddress) || (emailAddress = StringUtils.trimToNull((String)((InternetAddress)a).getAddress())) == null) continue;
                senders.add(emailAddress.toLowerCase());
            }
        } else {
            for (String sender : MailUtils.getSenders((Message)message)) {
                if (!StringUtils.isNotBlank((String)sender) || hasReplyTo && sender.toLowerCase().startsWith("noreply")) continue;
                senders.add(sender.toLowerCase());
            }
        }
        return senders;
    }

    public static HashSet<String> getEmailAddresses(Message message, Message.RecipientType ... recipientTypes) {
        HashSet<String> emailAddresses = new HashSet<String>();
        for (Message.RecipientType type : recipientTypes) {
            emailAddresses.addAll(MailUtil.getEmailAddresses(message, type));
        }
        return emailAddresses;
    }

    public static HashSet<String> getEmailAddresses(Message message, Message.RecipientType recipientType) {
        HashSet<String> emailAddresses = new HashSet<String>();
        try {
            Address[] addresses = message.getRecipients(recipientType);
            if (addresses != null && addresses.length > 0) {
                for (Address a : addresses) {
                    if (!(a instanceof InternetAddress)) continue;
                    emailAddresses.add(((InternetAddress)a).getAddress());
                }
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return emailAddresses;
    }

    public static Map<EmailField, String> toMap(Message message) throws MessagingException {
        HashMap<EmailField, String> emailFields = new HashMap<EmailField, String>();
        emailFields.put(EmailField.BODY, MailUtils.getBody((Message)message));
        emailFields.put(EmailField.SUBJECT, message.getSubject());
        HashSet<String> senderEmailAddressesInLowerCase = MailUtil.getSendersInLowerCase(message);
        HashSet<String> recipients = MailUtil.getEmailAddresses(message, Message.RecipientType.TO);
        recipients.addAll(MailUtil.getEmailAddresses(message, Message.RecipientType.CC));
        emailFields.put(EmailField.SENDER, senderEmailAddressesInLowerCase == null || senderEmailAddressesInLowerCase.isEmpty() ? null : (String)senderEmailAddressesInLowerCase.iterator().next());
        emailFields.put(EmailField.RECIPIENTS, StringUtils.join(recipients, (String)","));
        if (message.getFrom() != null && message.getFrom().length > 0 && message.getFrom()[0] instanceof InternetAddress) {
            emailFields.put(EmailField.SENDER_NAME, ((InternetAddress)message.getFrom()[0]).getPersonal());
        }
        return emailFields;
    }

    public static boolean hasHeader(Message message, String headerName, String headerValue) throws MessagingException {
        return message != null && message.getHeader(headerName) != null && message.getHeader(headerName).length > 0 && message.getHeader(headerName)[0] != null && (headerValue == null || message.getHeader(headerName)[0].toLowerCase().contains(headerValue.toLowerCase()));
    }

    public static boolean hasHeader(Message message, String headerName) throws MessagingException {
        return message != null && message.getHeader(headerName) != null;
    }

    public static List<Attachment> getAttachments(Message message) throws MessagingException, IOException {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (MailUtil.getContent((Part)message) instanceof Multipart) {
            MailUtil.addAttachments(attachments, (Multipart)MailUtil.getContent((Part)message));
        } else if (MailUtil.isAttachment((Part)message)) {
            attachments.add(MailUtil.buildAttachment((Part)message));
        }
        return attachments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getContent(Part part) throws MessagingException, IOException {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        try {
            Object object;
            currentThread.setContextClassLoader(MailUtils.class.getClassLoader());
            Object object2 = object = part.getContent();
            return object2;
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    private static void addAttachments(List<Attachment> attachments, Multipart parts) throws MessagingException, IOException {
        int n = parts.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part = parts.getBodyPart(i);
            if (MailUtil.isAttachment((Part)part)) {
                attachments.add(MailUtil.buildAttachment((Part)part));
                continue;
            }
            try {
                Object content = MailUtil.getContent((Part)part);
                if (content instanceof Message) {
                    attachments.addAll(MailUtil.getAttachments((Message)content));
                    continue;
                }
                if (!(content instanceof Multipart)) continue;
                MailUtil.addAttachments(attachments, (Multipart)content);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                logger.warn((Object)"Unsupported encoding found for part while trying to discover attachments. Attachment will be ignored.", (Throwable)e);
            }
        }
    }

    public static boolean isAttachment(Part part) throws MessagingException {
        return "attachment".equalsIgnoreCase(part.getDisposition()) || part.getDisposition() == null && StringUtils.isNotBlank((String)part.getFileName()) || MailUtils.isPartInline((Part)part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attachment buildAttachment(Part part) throws IOException, MessagingException {
        InputStream content = null;
        try {
            Attachment attachment;
            content = part.getInputStream();
            String contentType = part.getContentType();
            if (contentType != null && contentType.indexOf(";") > 0) {
                contentType = contentType.substring(0, contentType.indexOf(";"));
            }
            if (contentType != null && contentType.indexOf("\r") > 0) {
                contentType = contentType.substring(0, contentType.indexOf("\r"));
            }
            if (contentType != null && !contentType.endsWith(";")) {
                contentType = contentType + ";";
            }
            String contentId = MailUtil.getContentId(part);
            byte[] contents = IOUtils.toByteArray((InputStream)content);
            String fileName = MimeUtility.decodeText((String)MailUtil.getAttachmentFilename(part, contents));
            Attachment attachment2 = attachment = new Attachment(contentId, contentType, fileName, contents);
            return attachment2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    public static String getContentId(Part part) throws MessagingException {
        String[] contentIds = part.getHeader("Content-ID");
        if (contentIds != null) {
            for (String contentId : contentIds) {
                if (!StringUtils.isNotEmpty((String)contentId)) continue;
                return StringUtils.strip((String)contentId, (String)"<>");
            }
        }
        return "";
    }

    static String getAttachmentFilename(Part attachment, byte[] contents) throws MessagingException, IOException {
        String fileName = attachment.getFileName();
        String fileExtension = "";
        if (fileName == null) {
            fileName = RandomStringUtils.randomAlphanumeric((int)8);
            if (MailUtils.isPartMessageType((Part)attachment)) {
                Part innerMessage = (Part)MailUtil.getContent(attachment);
                String[] subjects = innerMessage != null ? innerMessage.getHeader("Subject") : new String[]{};
                String[] arrstring = subjects;
                if (subjects != null && subjects.length > 0) {
                    fileExtension = "eml";
                    fileName = MailUtil.sanitizeFilenameFromMailSubject(subjects[0]);
                }
            } else {
                ImageInfo imageInfo = new ImageInfo();
                imageInfo.setInput(new ByteArrayInputStream(contents));
                imageInfo.check();
                String formatName = imageInfo.getFormatName();
                if (StringUtils.isNotBlank((String)formatName) && !formatName.trim().equals("?")) {
                    fileExtension = formatName.toLowerCase();
                } else if (MailUtils.getContentType((Part)attachment).startsWith("image/")) {
                    fileExtension = MailUtils.getContentType((Part)attachment).substring("image/".length());
                }
            }
        }
        return StringUtils.isNotEmpty((String)fileExtension) ? String.format("%s.%s", fileName, fileExtension) : fileName;
    }

    static String sanitizeFilenameFromMailSubject(String subject) {
        return subject.replaceAll("[\\.\\-\\*#\\|\\{\\}:=%\\?\\+\\^\\~!\\\\\\/@\\[\\]\\'\"`\\$\\(\\);& ]", "_");
    }
}

