/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.util.AttachmentException;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.handler.RichTextMailUtils;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.mail.Message;

public class IssueSupportingMessageHandlerContext
implements MessageHandlerContext {
    private final Message message;
    private MessageHandlerContext context;
    private Issue issueAffected;
    private Comment commentAdded;
    private ApplicationUser actingUser;
    private AuditLogEntry auditLogEntry;
    private List<String> attachmentNames = new LinkedList<String>();
    private Map<String, Map<String, JSONObject>> commentProperties = new HashMap<String, Map<String, JSONObject>>();

    public IssueSupportingMessageHandlerContext(MessageHandlerContext context, Message message) {
        this.context = context;
        this.message = message;
    }

    public ApplicationUser createUser(String s, String s2, String s3, String s4, Integer integer) throws PermissionException, CreateException {
        return this.context.createUser(s, s2, s3, s4, integer);
    }

    public MessageHandlerContext getContext() {
        return this.context;
    }

    public void setContext(MessageHandlerContext context) {
        this.context = context;
    }

    public Comment createComment(Issue issue, ApplicationUser user, String s, boolean b) {
        this.commentAdded = this.context.createComment(issue, user, s, b);
        this.issueAffected = issue;
        this.actingUser = user;
        return this.commentAdded;
    }

    public Issue createIssue(ApplicationUser user, Issue issue) throws CreateException {
        this.issueAffected = this.context.createIssue(user, issue);
        this.actingUser = user;
        return this.issueAffected;
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, ApplicationUser user, Issue issue) throws AttachmentException {
        try {
            Map<String, String> filenames = RichTextMailUtils.getFilenamesWithCid(this.message);
            if (filenames != null && filenames.containsKey(filename)) {
                String cid = filenames.get(filename);
                filename = RichTextMailUtils.buildAttachmentName(filename, cid);
            }
        }
        catch (Exception filenames) {
            // empty catch block
        }
        ChangeItemBean cib = this.context.createAttachment(file, filename, contentType, user, issue);
        if (cib != null) {
            this.attachmentNames.add(filename);
        }
        return cib;
    }

    public boolean isRealRun() {
        return this.context.isRealRun();
    }

    public MessageHandlerExecutionMonitor getMonitor() {
        return this.context.getMonitor();
    }

    public Issue getIssueAffected() {
        return this.issueAffected;
    }

    public void setIssueAffected(Issue issueAffected) {
        this.issueAffected = issueAffected;
    }

    public Comment getCommentAdded() {
        return this.commentAdded;
    }

    public ApplicationUser getActingUser() {
        return this.actingUser;
    }

    public void addCommentProperty(String entityName, String key, JSONObject value) {
        Map<String, JSONObject> property = this.commentProperties.get(entityName);
        if (property == null) {
            property = new HashMap<String, JSONObject>();
            this.commentProperties.put(entityName, property);
        }
        property.put(key, value);
    }

    public AuditLogEntry getAuditLogEntry() {
        return this.auditLogEntry;
    }

    public void setAuditLogEntry(AuditLogEntry auditLogEntry) {
        this.auditLogEntry = auditLogEntry;
    }

    public List<String> getAttachmentNames() {
        return this.attachmentNames;
    }

    public Map<String, Map<String, JSONObject>> getCommentProperties() {
        return this.commentProperties;
    }
}

