/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.core.util.ImageInfo;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.Part;
import org.apache.commons.lang.StringUtils;

class GeneratedAttachmentRecogniser {
    public static final String IMAGE_FORMAT = "javax_imageio_png_1.0";
    private final boolean isJiraGeneratedAttachment;
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_ID = "Content-ID";
    private final String JIRA_SYSTEM_IMAGE_TYPE = "jira-system-image-type";

    public GeneratedAttachmentRecogniser(Part part) {
        this.isJiraGeneratedAttachment = this.containsJiraHeader(part) || this.containsJiraMetadata(part);
    }

    private boolean isPng(Part part) {
        String[] contentTypeHeaders;
        for (String contentTypeHeader : contentTypeHeaders = this.tryAndGetHeader(part, CONTENT_TYPE)) {
            if (!StringUtils.startsWithIgnoreCase((String)contentTypeHeader, (String)"image/png")) continue;
            return true;
        }
        return false;
    }

    public boolean isJiraGeneratedAttachment() {
        return this.isJiraGeneratedAttachment;
    }

    private boolean containsJiraMetadata(Part part) {
        if (!this.isPng(part)) {
            return false;
        }
        try {
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setInput(part.getInputStream());
            imageInfo.setExpectedPngTextKeyword("jira-system-image-type");
            if (imageInfo.check()) {
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        catch (MessagingException e) {
            return false;
        }
        return false;
    }

    private boolean containsJiraHeader(Part part) {
        String[] headers;
        for (String header : headers = this.tryAndGetHeader(part, CONTENT_ID)) {
            if (!header.startsWith("<jira-generated-image-")) continue;
            return true;
        }
        return false;
    }

    private String[] tryAndGetHeader(Part part, String name) {
        try {
            String[] header = part.getHeader(name);
            return header == null ? new String[]{} : header;
        }
        catch (MessagingException e) {
            return new String[0];
        }
    }
}

