/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.customfields.impl.TextAreaCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.atlassian.jira.service.util.handler.MessageUserProcessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.mail.MailUtils;
import com.google.common.collect.Sets;
import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.action.EmailSource;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.converters.ConverterFactory;
import com.metainf.jira.plugin.emailissue.converters.wiki.Attachment;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.entity.AttachmentNameFilter;
import com.metainf.jira.plugin.emailissue.entity.AttachmentNameFilterDao;
import com.metainf.jira.plugin.emailissue.entity.AuditLogDao;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParamsDao;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.entity.FieldContext;
import com.metainf.jira.plugin.emailissue.entity.FieldContextDao;
import com.metainf.jira.plugin.emailissue.entity.FieldRule;
import com.metainf.jira.plugin.emailissue.entity.MD5Pattern;
import com.metainf.jira.plugin.emailissue.entity.MD5PatternDao;
import com.metainf.jira.plugin.emailissue.entity.MailHandlerLog;
import com.metainf.jira.plugin.emailissue.entity.MailHandlerLogDao;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.field.EmailFilterAction;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.handler.CreateOrCommentHandler;
import com.metainf.jira.plugin.emailissue.handler.IssueSupportingMessageHandlerContext;
import com.metainf.jira.plugin.emailissue.handler.JETIMailHandler;
import com.metainf.jira.plugin.emailissue.handler.MailHandlerContext;
import com.metainf.jira.plugin.emailissue.handler.MailUtil;
import com.metainf.jira.plugin.emailissue.handler.MessageProxy;
import com.metainf.jira.plugin.emailissue.handler.RichTextMailUtils;
import com.metainf.jira.plugin.emailissue.mail.EmailBean;
import com.metainf.jira.plugin.emailissue.mail.EmailSender;
import com.metainf.jira.plugin.emailissue.operation.PermissionChecker;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import com.metainf.jira.plugin.emailissue.template.MailTemplateManager;
import com.metainf.jira.plugin.emailissue.template.Renderer;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.util.Base64Util;
import com.metainf.jira.plugin.emailissue.util.CollectionUtils;
import com.metainf.jira.plugin.emailissue.util.MD5Util;
import com.metainf.jira.plugin.emailissue.util.StringUtil;
import com.metainf.jira.plugin.emailissue.workflow.EmailDefinitionImpl;
import com.metainf.jira.plugin.emailissue.workflow.IssueTransitioner;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class EmailThisIssueMailHandler
extends CreateOrCommentHandler
implements MessageHandler,
JETIMailHandler {
    private static Logger logger = Logger.getLogger(EmailThisIssueMailHandler.class);
    private Authorizer authorizer;
    private EmailSender emailSender;
    private CustomFieldManager customFieldManager;
    private MessageUserProcessor messageUserProcessor;
    private IssueFactory issueFactory;
    private ConfigurationManager configurationManager;
    private final FieldLayoutManager fieldLayoutManager;
    private JiraAuthenticationContext authenticationContext;
    private AutoReplyParamsDao autoReplyParamsDao;
    private IssueManager issueManager;
    private WatcherManager watcherManager;
    private final AuditLogDao auditLogDao;
    private MessageHandlerErrorCollector messageHandlerErrorCollection;
    private Map<String, String> params;
    private final ProjectManager projectManager;
    private AutoReplyParams mailHandlerParams;
    private final MD5PatternDao md5PatternDao;
    private final AttachmentNameFilterDao attachmentNameFilterDao;
    private final CommentManager commentManager;
    private final IssueSearcher issueSearcher;
    private final IssueLinkManager issueLinkManager;
    private final EventTypeManager eventTypeManager;
    private final IssueEventManager issueEventManager;
    private final IssueTransitioner issueTransitioner;
    private final RendererManager rendererManager;
    private final FieldContextProcessor fieldContextProcessor;
    private final FieldContextDao fieldContextDao;
    private final MailTemplateManager mailTemplateManager;
    private final ActiveObjects ao;
    private final UserResolver userResolver;
    private final MailHandlerLogDao mailHandlerLogDao;
    private Configuration globalConfiguration;
    private final ServiceDeskManager serviceDeskManager;
    private final PermissionChecker permissionChecker;
    public static final ThreadLocal<String> externalEmailSender = new ThreadLocal();

    public EmailThisIssueMailHandler(AuditLogDao auditLogDao, ProjectManager projectManager, WatcherManager watcherManager, IssueManager issueManager, AutoReplyParamsDao autoReplyParamsDao, JiraAuthenticationContext authenticationContext, ConfigurationManager configurationManager, IssueFactory issueFactory, MessageUserProcessor messageUserProcessor, CustomFieldManager customFieldManager, EmailSender emailSender, Authorizer authorizer, FieldLayoutManager fieldLayoutManager, MD5PatternDao md5PatternDao, AttachmentNameFilterDao attachmentNameFilterDao, IssueSearcher issueSearcher, IssueLinkManager issueLinkManager, EventTypeManager eventTypeManager, IssueEventManager issueEventManager, IssueTransitioner issueTransitioner, RendererManager rendererManager, FieldContextProcessor fieldContextProcessor, FieldContextDao fieldContextDao, MailTemplateManager mailTemplateManager, ActiveObjects ao, UserResolver userResolver, MailHandlerLogDao mailHandlerLogDao, ServiceDeskManager serviceDeskManager, CommentManager commentManager, PermissionChecker permissionChecker) {
        this.auditLogDao = auditLogDao;
        this.projectManager = projectManager;
        this.watcherManager = watcherManager;
        this.issueManager = issueManager;
        this.autoReplyParamsDao = autoReplyParamsDao;
        this.authenticationContext = authenticationContext;
        this.configurationManager = configurationManager;
        this.issueFactory = issueFactory;
        this.messageUserProcessor = messageUserProcessor;
        this.customFieldManager = customFieldManager;
        this.emailSender = emailSender;
        this.authorizer = authorizer;
        this.fieldLayoutManager = fieldLayoutManager;
        this.md5PatternDao = md5PatternDao;
        this.attachmentNameFilterDao = attachmentNameFilterDao;
        this.issueLinkManager = issueLinkManager;
        this.issueSearcher = issueSearcher;
        this.eventTypeManager = eventTypeManager;
        this.issueEventManager = issueEventManager;
        this.issueTransitioner = issueTransitioner;
        this.rendererManager = rendererManager;
        this.fieldContextProcessor = fieldContextProcessor;
        this.fieldContextDao = fieldContextDao;
        this.mailTemplateManager = mailTemplateManager;
        this.ao = ao;
        this.userResolver = userResolver;
        this.mailHandlerLogDao = mailHandlerLogDao;
        this.serviceDeskManager = serviceDeskManager;
        this.commentManager = commentManager;
        this.permissionChecker = permissionChecker;
    }

    @Override
    public void init(Map<String, String> params, MessageHandlerErrorCollector messageHandlerErrorCollector) {
        super.init(params, messageHandlerErrorCollector);
        this.params = params;
        this.messageHandlerErrorCollection = messageHandlerErrorCollector;
    }

    private MessageHandler createAndInitMailHandlerDelegate(AutoReplyParams mailHandlerParams) {
        AutoReplyParams.ProcessingType pt = mailHandlerParams.getProcessingStrategy() == null ? AutoReplyParams.ProcessingType.CREATE_OR_COMMENT : mailHandlerParams.getProcessingStrategy();
        MessageHandler delegate = pt.getMailHandler(mailHandlerParams, this.issueLinkManager, this.issueSearcher, this.fieldContextProcessor, this.mailTemplateManager, this.issueTransitioner, this.ao);
        delegate.init(this.params, this.messageHandlerErrorCollection);
        return delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMessage(final Message message, final MessageHandlerContext context) throws MessagingException {
        final boolean validLicense = this.authorizer.authorize().isValid();
        if (!validLicense) {
            logger.warn((Object)"EmailThisIssue licence is invalid. Contact us at info@meta-inf.hu.");
            return false;
        }
        this.globalConfiguration = this.configurationManager.getGlobalConfiguration();
        final HashSet<String> senderEmailAddressesInLowerCase = MailUtil.getSendersInLowerCase(message);
        final HashSet<ApplicationUser> senderUsers = this.filterForUsers(new HashSet<String>(senderEmailAddressesInLowerCase));
        final IssueSupportingMessageHandlerContext mhc = new IssueSupportingMessageHandlerContext(null, message);
        mhc.setContext(new MessageHandlerContext(){

            public ApplicationUser createUser(String s, String s1, String s2, String s3, Integer integer) throws PermissionException, CreateException {
                return context.createUser(s, s1, s2, s3, integer);
            }

            public Comment createComment(Issue issue, ApplicationUser user, String commentBody, boolean b) {
                Comment newComment;
                block22: {
                    newComment = null;
                    if (StringUtils.isBlank((String)commentBody) || StringUtils.isWhitespace((String)commentBody)) {
                        return null;
                    }
                    String originalCommentBody = commentBody;
                    try {
                        AutoReplyParams autoReplyParams = EmailThisIssueMailHandler.this.resolveAutoReplyContexts(issue);
                        if (!validLicense || autoReplyParams == null) break block22;
                        HashSet<String> excludeEmails = StringUtils.isNotBlank((String)autoReplyParams.getExcludeEmailsRegex()) ? new HashSet<String>(Arrays.asList(autoReplyParams.getExcludeEmailsRegex().toLowerCase().split("\r\n"))) : new HashSet();
                        boolean issueChanged = EmailThisIssueMailHandler.this.saveSenderInField(message, issue, user, autoReplyParams, new HashSet(senderEmailAddressesInLowerCase), excludeEmails);
                        HashSet<String> recipientEmailAddresses = MailUtil.getEmailAddresses(message, MimeMessage.RecipientType.TO);
                        HashSet<String> copyRecipientEmailAddresses = MailUtil.getEmailAddresses(message, MimeMessage.RecipientType.CC);
                        boolean handleUserRecipients = EmailThisIssueMailHandler.this.mustHandlerUserRecipients(autoReplyParams);
                        HashSet<Object> recipientUsers = handleUserRecipients ? EmailThisIssueMailHandler.this.filterForUsers(recipientEmailAddresses) : new HashSet();
                        HashSet<Object> copyRecipientUsers = handleUserRecipients ? EmailThisIssueMailHandler.this.filterForUsers(copyRecipientEmailAddresses) : new HashSet();
                        issueChanged |= EmailThisIssueMailHandler.this.saveRecipients(issue, recipientEmailAddresses, autoReplyParams, autoReplyParams.getRecipientFieldId(), excludeEmails);
                        issueChanged |= EmailThisIssueMailHandler.this.saveRecipients(issue, copyRecipientEmailAddresses, autoReplyParams, autoReplyParams.getCopyRecipientFieldId(), excludeEmails);
                        recipientUsers.addAll(copyRecipientUsers);
                        if (handleUserRecipients && !recipientUsers.isEmpty()) {
                            issueChanged |= EmailThisIssueMailHandler.this.handleUserRecipients(issue, autoReplyParams, recipientUsers);
                        }
                        if (Boolean.TRUE.equals(autoReplyParams.getInitializeIssueFields())) {
                            issueChanged |= EmailThisIssueMailHandler.this.initializeIssueFields((MutableIssue)issue, message, FieldRule.FieldRuleType.UPDATE);
                        }
                        if (issueChanged && issue instanceof MutableIssue) {
                            try {
                                EmailThisIssueMailHandler.this.issueManager.updateIssue(user, (MutableIssue)issue, EventDispatchOption.DO_NOT_DISPATCH, false);
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                        Renderer commentRenderer = EmailThisIssueMailHandler.this.getFieldRenderer(issue, "comment");
                        String richTextEmailContent = EmailThisIssueMailHandler.this.retrieveRichTextContent(issue, message, commentRenderer);
                        if (commentRenderer != Renderer.TEXT && issue instanceof MutableIssue) {
                            commentBody = EmailThisIssueMailHandler.this.truncateIfExceedingLimits(richTextEmailContent, true);
                            if (StringUtils.isNotBlank((String)autoReplyParams.getSplitregex())) {
                                String[] regex = autoReplyParams.getSplitregex().split("\r\n");
                                commentBody = RichTextMailUtils.splitMailBody(commentBody, regex, true);
                            }
                            if (commentRenderer == Renderer.WIKI) {
                                List<Attachment> attachments = MailUtil.getAttachments(message);
                                commentBody = ConverterFactory.createHtmlToWikiMarkupConverter(attachments).convert(commentBody);
                                try {
                                    for (Attachment attachment : attachments) {
                                        if (attachment.getContents() == null || attachment.getContents().length <= 0) continue;
                                        richTextEmailContent = RichTextMailUtils.base64Img(Base64Util.base64Encode(attachment.getContents()), attachment.getContentId(), attachment.getContentType(), richTextEmailContent);
                                    }
                                }
                                catch (Exception e) {
                                    EmailThisIssueMailHandler.this.log.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        } else if (Boolean.TRUE.equals(EmailThisIssueMailHandler.this.globalConfiguration.isFixOutlookBlankLine()) && EmailThisIssueMailHandler.this.isSentFromOutlook(message) && issue instanceof MutableIssue && commentBody != null) {
                            commentBody = commentBody.replace("\r\n\r\n", "\r\n");
                        }
                        if (!(user == null || user.getEmailAddress() == null || senderEmailAddressesInLowerCase.isEmpty() || senderEmailAddressesInLowerCase.contains(user.getEmailAddress().toLowerCase()) && EmailThisIssueMailHandler.this.permissionManager.hasPermission(ProjectPermissions.ADD_COMMENTS, issue.getProjectObject(), user))) {
                            commentBody = EmailThisIssueMailHandler.this.getI18nBean().getText("viewissue.comment.commentedby", (String)senderEmailAddressesInLowerCase.iterator().next(), "") + ": \n" + (commentBody == null ? "" : commentBody);
                        }
                        commentBody = EmailThisIssueMailHandler.this.sanitizeText(commentBody);
                        if (EmailThisIssueMailHandler.this.mailHandlerParams.getProcessingStrategy() != AutoReplyParams.ProcessingType.CREATE_OR_LOGEMAIL) {
                            newComment = context.createComment(issue, user, commentBody, b);
                        }
                        try {
                            if (autoReplyParams.getCommentTemplate() != null) {
                                EmailThisIssueMailHandler.this.sendAutoReply(issue, user, new HashSet(senderEmailAddressesInLowerCase), autoReplyParams.getCommentTemplate(), originalCommentBody);
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        EmailThisIssueMailHandler.this.createEmailLog(mhc, message.getSubject(), richTextEmailContent, user, issue, senderEmailAddressesInLowerCase, senderUsers, recipientEmailAddresses, recipientUsers, copyRecipientEmailAddresses, copyRecipientUsers, AuditLogEntry.EmailType.INCOMING_COMMENT);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (newComment == null && EmailThisIssueMailHandler.this.mailHandlerParams.getProcessingStrategy() != AutoReplyParams.ProcessingType.CREATE_OR_LOGEMAIL) {
                    commentBody = EmailThisIssueMailHandler.this.sanitizeText(commentBody);
                    newComment = context.createComment(issue, user, commentBody, b);
                }
                return newComment;
            }

            public Issue createIssue(ApplicationUser user, Issue issue) throws CreateException {
                Issue createdIssue;
                block23: {
                    String richTextEmailContent;
                    boolean handleUserRecipients;
                    HashSet copyRecipientUsers;
                    HashSet recipientUsers;
                    HashSet<String> copyRecipientEmailAddresses;
                    HashSet<String> recipientEmailAddresses;
                    AutoReplyParams autoReplyParams;
                    block22: {
                        autoReplyParams = null;
                        recipientEmailAddresses = new HashSet();
                        copyRecipientEmailAddresses = new HashSet();
                        recipientUsers = new HashSet();
                        copyRecipientUsers = new HashSet();
                        handleUserRecipients = false;
                        Renderer descriptionRenderer = EmailThisIssueMailHandler.this.getFieldRenderer(issue, "description");
                        richTextEmailContent = null;
                        try {
                            String truncatedDescription;
                            autoReplyParams = EmailThisIssueMailHandler.this.resolveAutoReplyContexts(issue);
                            if (!validLicense || autoReplyParams == null) break block22;
                            richTextEmailContent = EmailThisIssueMailHandler.this.retrieveRichTextContent(issue, message, descriptionRenderer);
                            HashSet<String> excludeEmails = StringUtils.isNotBlank((String)autoReplyParams.getExcludeEmailsRegex()) ? new HashSet<String>(Arrays.asList(autoReplyParams.getExcludeEmailsRegex().toLowerCase().split("\r\n"))) : new HashSet();
                            EmailThisIssueMailHandler.this.saveSenderInField(message, issue, user, autoReplyParams, new HashSet(senderEmailAddressesInLowerCase), excludeEmails);
                            recipientEmailAddresses = MailUtil.getEmailAddresses(message, MimeMessage.RecipientType.TO);
                            copyRecipientEmailAddresses = MailUtil.getEmailAddresses(message, MimeMessage.RecipientType.CC);
                            handleUserRecipients = EmailThisIssueMailHandler.this.mustHandlerUserRecipients(autoReplyParams);
                            recipientUsers = handleUserRecipients ? EmailThisIssueMailHandler.this.filterForUsers(recipientEmailAddresses) : new HashSet();
                            copyRecipientUsers = handleUserRecipients ? EmailThisIssueMailHandler.this.filterForUsers(copyRecipientEmailAddresses) : new HashSet();
                            EmailThisIssueMailHandler.this.saveRecipients(issue, recipientEmailAddresses, autoReplyParams, autoReplyParams.getRecipientFieldId(), excludeEmails);
                            EmailThisIssueMailHandler.this.saveRecipients(issue, copyRecipientEmailAddresses, autoReplyParams, autoReplyParams.getCopyRecipientFieldId(), excludeEmails);
                            if (descriptionRenderer == Renderer.JEDITOR && issue instanceof MutableIssue) {
                                truncatedDescription = EmailThisIssueMailHandler.this.truncateIfExceedingLimits(richTextEmailContent, true);
                                ((MutableIssue)issue).setDescription(truncatedDescription);
                            } else if (descriptionRenderer == Renderer.WIKI && issue instanceof MutableIssue) {
                                truncatedDescription = EmailThisIssueMailHandler.this.truncateIfExceedingLimits(richTextEmailContent, true);
                                List<Attachment> attachments = MailUtil.getAttachments(message);
                                String wikiMarkup = ConverterFactory.createHtmlToWikiMarkupConverter(attachments).convert(truncatedDescription);
                                if (Boolean.TRUE.equals(EmailThisIssueMailHandler.this.globalConfiguration.isFixOutlookBlankLine()) && EmailThisIssueMailHandler.this.isSentFromOutlook(message) && issue instanceof MutableIssue && wikiMarkup != null) {
                                    wikiMarkup = wikiMarkup.replace("\r\n\r\n", "\r\n");
                                }
                                ((MutableIssue)issue).setDescription(wikiMarkup);
                                try {
                                    for (Attachment attachment : attachments) {
                                        if (attachment.getContents() == null || attachment.getContents().length <= 0) continue;
                                        richTextEmailContent = RichTextMailUtils.base64Img(Base64Util.base64Encode(attachment.getContents()), attachment.getContentId(), attachment.getContentType(), richTextEmailContent);
                                    }
                                }
                                catch (Exception e) {
                                    EmailThisIssueMailHandler.this.log.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                            String desc = EmailThisIssueMailHandler.this.truncateIfExceedingLimits(issue.getDescription(), false);
                            ((MutableIssue)issue).setDescription(desc);
                            if (Boolean.TRUE.equals(autoReplyParams.getInitializeIssueFields())) {
                                logger.debug((Object)"Starting to initialize fields");
                                EmailThisIssueMailHandler.this.initializeIssueFields((MutableIssue)issue, message, FieldRule.FieldRuleType.SET);
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    ((MutableIssue)issue).setDescription(EmailThisIssueMailHandler.this.sanitizeText(issue.getDescription()));
                    ((MutableIssue)issue).setSummary(EmailThisIssueMailHandler.this.sanitizeText(issue.getSummary()));
                    HashSet allRecipientUsers = new HashSet(recipientUsers);
                    allRecipientUsers.addAll(copyRecipientUsers);
                    if (handleUserRecipients && !autoReplyParams.isUserRecipientsAsWatchers() && autoReplyParams.getUserRecipientFieldId() != null && !allRecipientUsers.isEmpty()) {
                        EmailThisIssueMailHandler.this.handleUserRecipients(issue, autoReplyParams, allRecipientUsers);
                    }
                    createdIssue = context.createIssue(user, issue);
                    logger.debug((Object)("Issue has been created: " + createdIssue));
                    if (createdIssue != null && createdIssue.getId() != null) {
                        try {
                            if (!validLicense || autoReplyParams == null) break block23;
                            boolean issueChanged = false;
                            if (Boolean.TRUE.equals(autoReplyParams.getInitializeIssueFields())) {
                                logger.debug((Object)"Starting to initialize fields");
                                EmailThisIssueMailHandler.this.initializeIssueFields((MutableIssue)issue, message, FieldRule.FieldRuleType.SET);
                            }
                            EmailThisIssueMailHandler.this.createEmailLog(mhc, message.getSubject(), richTextEmailContent, user, createdIssue, senderEmailAddressesInLowerCase, senderUsers, recipientEmailAddresses, recipientUsers, copyRecipientEmailAddresses, copyRecipientUsers, AuditLogEntry.EmailType.INCOMING_ISSUE);
                            try {
                                if (autoReplyParams.getTemplate() != null) {
                                    EmailThisIssueMailHandler.this.sendAutoReply(createdIssue, user, new HashSet(senderEmailAddressesInLowerCase), autoReplyParams.getTemplate(), null);
                                }
                            }
                            catch (MessagingException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                            if (handleUserRecipients && autoReplyParams.isUserRecipientsAsWatchers() && !allRecipientUsers.isEmpty()) {
                                issueChanged = EmailThisIssueMailHandler.this.handleUserRecipients(createdIssue, autoReplyParams, allRecipientUsers);
                            }
                            if (issueChanged && createdIssue instanceof MutableIssue) {
                                try {
                                    EmailThisIssueMailHandler.this.issueManager.updateIssue(user, (MutableIssue)createdIssue, EventDispatchOption.DO_NOT_DISPATCH, false);
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                        catch (Exception e) {
                            1 v0 = this;
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                return createdIssue;
            }

            public ChangeItemBean createAttachment(File file, String filename, String contentType, ApplicationUser author, Issue issue) throws AttachmentException {
                try {
                    MD5Pattern[] md5patterns;
                    EmailThisIssueMailHandler.this.log.info((Object)("context.createAttachment: " + filename + ", " + (file != null ? file.length() : -1L)));
                    Long fileSizeThresholdInKB = EmailThisIssueMailHandler.this.globalConfiguration.getFileSizeThreshold();
                    if (filename != null) {
                        AttachmentNameFilter[] nameFilters;
                        for (AttachmentNameFilter nameFilter : nameFilters = (AttachmentNameFilter[])EmailThisIssueMailHandler.this.attachmentNameFilterDao.findAll()) {
                            if (!filename.matches(nameFilter.getRegex())) continue;
                            return null;
                        }
                    }
                    if (fileSizeThresholdInKB != null && file.length() > 1024L * fileSizeThresholdInKB) {
                        EmailThisIssueMailHandler.this.log.info((Object)"context.createAttachment: attachment bypasses md5");
                        return context.createAttachment(file, filename, contentType, author, issue);
                    }
                    String md5OfNewAttachment = MD5Util.md5Hex(file);
                    for (MD5Pattern md5 : md5patterns = (MD5Pattern[])EmailThisIssueMailHandler.this.md5PatternDao.findAll()) {
                        if (!StringUtils.isNotBlank((String)md5.getPattern()) || !md5.getPattern().equalsIgnoreCase(md5OfNewAttachment)) continue;
                        EmailThisIssueMailHandler.this.log.info((Object)"context.createAttachment: attachment filtered out by md5");
                        return null;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                EmailThisIssueMailHandler.this.log.info((Object)"context.createAttachment: attachment passed md5 and being created");
                return context.createAttachment(file, filename, contentType, author, issue);
            }

            public boolean isRealRun() {
                return context.isRealRun();
            }

            public MessageHandlerExecutionMonitor getMonitor() {
                return context.getMonitor();
            }
        });
        List senders = MailUtils.getSenders((Message)message);
        if (this.isSenderBlacklisted(senders.isEmpty() ? null : (String)senders.get(0))) {
            String error = "Message rejected due to blacklisted sender: " + senders;
            context.getMonitor().warning(error);
            context.getMonitor().messageRejected(message, error);
            return false;
        }
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        try {
            boolean result;
            try {
                if (!senderUsers.isEmpty()) {
                    ApplicationUser firstSender = senderUsers.iterator().next();
                    this.authenticationContext.setLoggedInUser(firstSender);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            MessageHandler delegate = null;
            if (StringUtils.isNotBlank((String)this.projectKey) && StringUtils.isNotBlank((String)this.issueType)) {
                Issue issueRelatedToMessage = ServiceUtils.findIssueObjectInString((String)message.getSubject());
                if (!(issueRelatedToMessage == null || issueRelatedToMessage.getProjectObject().getKey().equalsIgnoreCase(this.projectKey) && issueRelatedToMessage.getIssueTypeId().equalsIgnoreCase(this.issueType))) {
                    this.mailHandlerParams = this.autoReplyParamsDao.resolveMailHandlerContext(issueRelatedToMessage.getProjectId(), Long.parseLong(issueRelatedToMessage.getIssueTypeId()));
                }
                Project affectedProject = null;
                String affectedIssueType = null;
                if (this.mailHandlerParams == null || issueRelatedToMessage == null) {
                    affectedProject = this.projectManager.getProjectObjByKey(this.projectKey);
                    affectedIssueType = this.issueType;
                    if (affectedProject != null) {
                        this.mailHandlerParams = this.autoReplyParamsDao.resolveMailHandlerContext(affectedProject.getId(), Long.parseLong(this.issueType));
                    }
                } else {
                    affectedProject = issueRelatedToMessage.getProjectObject();
                    affectedIssueType = issueRelatedToMessage.getIssueTypeId();
                }
                if (this.mailHandlerParams != null) {
                    EmailFilterAction action;
                    if (this.mailHandlerLogDao.exists(message, this.mailHandlerParams)) {
                        logger.warn((Object)"Mail Message appears to be in Mail Handler Log, processing skips it now.");
                        boolean bl = false;
                        return bl;
                    }
                    if (Boolean.TRUE.equals(this.mailHandlerParams.isFilterEmails()) && (action = this.filterEmail(message, affectedProject.getId(), Long.parseLong(affectedIssueType))) != null) {
                        action.doAction(message);
                        boolean bl = false;
                        return bl;
                    }
                    delegate = this.createAndInitMailHandlerDelegate(this.mailHandlerParams);
                }
            }
            if (!senderEmailAddressesInLowerCase.isEmpty()) {
                externalEmailSender.set(senderUsers.isEmpty() ? senderEmailAddressesInLowerCase.iterator().next() : null);
            } else {
                externalEmailSender.set(null);
            }
            MessageProxy messageProxy = new MessageProxy(message);
            MailHandlerContext.setCurrentContext(this.mailHandlerParams);
            boolean bl = result = delegate != null ? delegate.handleMessage((Message)messageProxy, (MessageHandlerContext)mhc) : super.handleMessage(messageProxy, mhc);
            if (result && mhc.getIssueAffected() != null) {
                AutoReplyParams params = this.resolveAutoReplyContexts(mhc.getIssueAffected());
                if (params != null && Boolean.TRUE.equals(params.isExecuteTransition())) {
                    this.transitionIssue(mhc.getIssueAffected(), message);
                }
                if (mhc.getAuditLogEntry() != null && !mhc.getAttachmentNames().isEmpty()) {
                    mhc.getAuditLogEntry().setAttachments(StringUtils.join(mhc.getAttachmentNames(), (String)", "));
                    this.auditLogDao.update(mhc.getAuditLogEntry());
                }
            }
            boolean bl2 = result;
            return bl2;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.createMailHandlerLog(message, mhc, e);
            boolean bl = mhc.getCommentAdded() == null && mhc.getIssueAffected() == null;
            return bl;
        }
        finally {
            MailHandlerContext.setCurrentContext(null);
            this.authenticationContext.setLoggedInUser(currentUser);
            externalEmailSender.set(null);
        }
    }

    private void createMailHandlerLog(Message message, IssueSupportingMessageHandlerContext mhc, Exception e) {
        try {
            if (message != null && this.mailHandlerParams != null) {
                MailHandlerLog mailHandlerLog = (MailHandlerLog)this.mailHandlerLogDao.create();
                mailHandlerLog.setCc(StringUtils.join(MailUtil.getEmailAddresses(message, Message.RecipientType.CC), (String)","));
                mailHandlerLog.setRecipients(StringUtils.join(MailUtil.getEmailAddresses(message, Message.RecipientType.TO), (String)","));
                if (message instanceof MimeMessage) {
                    mailHandlerLog.setContentEncoding(((MimeMessage)message).getEncoding());
                    mailHandlerLog.setContentId(((MimeMessage)message).getContentID());
                    mailHandlerLog.setMessageId(((MimeMessage)message).getMessageID());
                }
                logger.info((Object)"Mail log: contnet attributes set");
                String body = TextUtils.plainTextToHtml((String)MailUtils.getBody((Message)message));
                String sanitizedBody = this.sanitizeText(body);
                mailHandlerLog.setEmailBody(sanitizedBody);
                String sanitizedSubject = this.sanitizeText(message.getSubject());
                mailHandlerLog.setEmailSubject(sanitizedSubject);
                mailHandlerLog.setFlags(null);
                if (message.getFrom() != null && message.getFrom().length > 0 && message.getFrom()[0] instanceof InternetAddress) {
                    String emailAddress = ((InternetAddress)message.getFrom()[0]).getAddress();
                    mailHandlerLog.setFromAddress(emailAddress != null ? emailAddress.toLowerCase() : null);
                    mailHandlerLog.setFromName(((InternetAddress)message.getFrom()[0]).getPersonal());
                }
                logger.info((Object)("Mail log: effected issue: " + mhc.getIssueAffected()));
                if (mhc != null && mhc.getIssueAffected() != null) {
                    mailHandlerLog.setIssueId(mhc.getIssueAffected().getId());
                    mailHandlerLog.setIssueKey(mhc.getIssueAffected().getKey());
                    mailHandlerLog.setIssueSummary(mhc.getIssueAffected().getSummary());
                }
                logger.info((Object)"Mail log: issue set");
                mailHandlerLog.setMailHandlerContext(this.mailHandlerParams);
                mailHandlerLog.setProcessedDate(new Date());
                mailHandlerLog.setReceivedDate(message.getReceivedDate());
                mailHandlerLog.setSentDate(message.getSentDate());
                logger.info((Object)"Mail log: dates set");
                String error = TextUtils.plainTextToHtml((String)ExceptionUtils.getFullStackTrace((Throwable)e));
                String sanitizedError = this.sanitizeText(error);
                mailHandlerLog.setErrorTrace(sanitizedError);
                logger.info((Object)("Mail log: error trace set: " + error.length()));
                this.mailHandlerLogDao.update(mailHandlerLog);
                logger.info((Object)"Mail log: saved");
            }
        }
        catch (Exception ex) {
            logger.info((Object)"Mail log: error");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private EmailFilterAction filterEmail(Message message, Long projectId, Long issueTypeId) throws MessagingException {
        FieldContext fieldContext;
        EmailFilterAction action = null;
        if (projectId != null && issueTypeId != null && (fieldContext = this.fieldContextDao.resolve(projectId, Long.parseLong(this.issueType))) != null) {
            EmailBean emailBean = new EmailBean(message);
            emailBean.setBody(this.sanitizeText(emailBean.getBody()));
            emailBean.setSubject(this.sanitizeText(emailBean.getSubject()));
            action = this.fieldContextProcessor.filterEmail(fieldContext, emailBean);
        }
        return action;
    }

    private void transitionIssue(Issue issue, Message message) {
        try {
            FieldContext fieldContext = this.fieldContextDao.resolve(issue);
            if (fieldContext != null) {
                logger.debug((Object)"Context found for transitioning issue via field rules");
                EmailBean emailBean = new EmailBean(message);
                emailBean.setBody(this.sanitizeText(emailBean.getBody()));
                emailBean.setSubject(this.sanitizeText(emailBean.getSubject()));
                this.fieldContextProcessor.transitionIssue(fieldContext, issue, emailBean, this.getDefaultReporter());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Execution of transitions failed (email is processed regardless of this problem): " + e.getMessage()), (Throwable)e);
        }
        this.issueTransitioner.transitionIssue(issue, this.getDefaultReporter());
    }

    private boolean initializeIssueFields(MutableIssue issue, Message message, FieldRule.FieldRuleType fieldRuleType) throws MessagingException {
        boolean issueChanged = false;
        try {
            FieldContext fieldContext = this.fieldContextDao.resolve((Issue)issue);
            if (fieldContext != null) {
                logger.debug((Object)"Context found for field initialization");
                EmailBean emailBean = new EmailBean(message);
                emailBean.setBody(this.sanitizeText(emailBean.getBody()));
                emailBean.setSubject(this.sanitizeText(emailBean.getSubject()));
                issueChanged = this.fieldContextProcessor.initializeIssueFields(fieldContext, issue, emailBean, fieldRuleType);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Issue field initialization failed (email is processed regardless of this problem): " + e.getMessage()), (Throwable)e);
        }
        return issueChanged;
    }

    private boolean isSentFromOutlook(Message message) throws MessagingException {
        return MailUtil.hasHeader(message, "X-Mailer", "Outlook") || MailUtil.hasHeader(message, "X-MS-Has-Attach");
    }

    private boolean isSenderBlacklisted(String sender) throws MessagingException {
        String[] blacklistRegexes;
        String blacklist = this.globalConfiguration.getSenderBlacklist();
        String[] stringArray = blacklistRegexes = StringUtils.isNotBlank((String)blacklist) ? blacklist.split("\r\n") : new String[]{};
        if (blacklistRegexes != null && blacklistRegexes.length > 0) {
            for (String regex : blacklistRegexes) {
                if (!sender.matches(regex)) continue;
                return true;
            }
        }
        return false;
    }

    private Renderer getFieldRenderer(Issue issue, String field) {
        FieldLayoutItem fli = this.fieldLayoutManager.getFieldLayout(issue).getFieldLayoutItem(field);
        Renderer renderer = Renderer.WIKI;
        if (fli != null) {
            if (Renderer.JEDITOR.getKey().equalsIgnoreCase(fli.getRendererType())) {
                renderer = Renderer.JEDITOR;
            } else if (Renderer.TEXT.getKey().equalsIgnoreCase(fli.getRendererType())) {
                renderer = Renderer.TEXT;
            } else if (Renderer.WIKI.getKey().equalsIgnoreCase(fli.getRendererType())) {
                renderer = Renderer.WIKI;
            }
        }
        return renderer;
    }

    private String retrieveRichTextContent(Issue issue, Message message, Renderer fieldRenderer) throws MessagingException {
        String content = RichTextMailUtils.getRichTextContent(issue, message, fieldRenderer);
        return content;
    }

    private boolean handleUserRecipients(Issue issue, AutoReplyParams autoReplyParams, HashSet<ApplicationUser> recipientUsers) {
        if (autoReplyParams.isUserRecipientsAsWatchers()) {
            for (ApplicationUser watcher : recipientUsers) {
                if (!this.permissionChecker.isAllowedToViewIssue(watcher, issue)) continue;
                this.watcherManager.startWatching(watcher, issue);
            }
        } else if (issue instanceof MutableIssue) {
            MutableIssue mutableIssue = (MutableIssue)issue;
            CustomField multiUserField = this.customFieldManager.getCustomFieldObject(autoReplyParams.getUserRecipientFieldId());
            if (multiUserField != null) {
                HashSet<ApplicationUser> currentUsersInField = (HashSet<ApplicationUser>)mutableIssue.getCustomFieldValue(multiUserField);
                if (currentUsersInField == null) {
                    currentUsersInField = recipientUsers;
                } else {
                    recipientUsers.removeAll(currentUsersInField);
                    currentUsersInField.addAll(recipientUsers);
                }
                mutableIssue.setCustomFieldValue(multiUserField, currentUsersInField);
                return true;
            }
        }
        return false;
    }

    private boolean mustHandlerUserRecipients(AutoReplyParams autoReplyParams) {
        return autoReplyParams.isUserRecipientsAsWatchers() || autoReplyParams.getUserRecipientFieldId() != null && this.customFieldManager.getCustomFieldObject(autoReplyParams.getUserRecipientFieldId()) != null;
    }

    private void createEmailLog(IssueSupportingMessageHandlerContext context, String subject, String body, ApplicationUser user, Issue issue, HashSet<String> senderEmailAddresses, HashSet<ApplicationUser> senderUsers, HashSet<String> recipientEmailAddresses, HashSet<ApplicationUser> recipientUsers, HashSet<String> copyRecipientEmailAddresses, HashSet<ApplicationUser> copyRecipientUsers, AuditLogEntry.EmailType type) {
        String to = this.join(recipientEmailAddresses, recipientUsers);
        String cc = this.join(copyRecipientEmailAddresses, copyRecipientUsers);
        String fromEmail = senderEmailAddresses != null && !senderEmailAddresses.isEmpty() ? senderEmailAddresses.iterator().next() : null;
        String fromName = senderUsers != null && !senderUsers.isEmpty() ? senderUsers.iterator().next().getDisplayName() : null;
        String attachments = null;
        AuditLogEntry auditLogEntry = this.auditLogDao.create(user, issue, subject, body, fromEmail, fromName, to, cc, null, null, false, false, false, attachments, null, null, false, type);
        context.setAuditLogEntry(auditLogEntry);
    }

    protected String join(HashSet<String> emailAddresses, HashSet<ApplicationUser> users) {
        StringBuilder result = new StringBuilder(StringUtils.join(emailAddresses, (String)", "));
        Iterator<ApplicationUser> it = users.iterator();
        while (it.hasNext()) {
            if (it.hasNext() && result.length() > 0) {
                result.append(", ");
            }
            ApplicationUser u = it.next();
            result.append(u.getEmailAddress());
        }
        return result.toString();
    }

    protected HashSet<ApplicationUser> filterForUsers(HashSet<String> emailAddressesInLowerCase) {
        HashSet<String> userEmailAddressesInLowerCase = new HashSet<String>();
        HashSet<ApplicationUser> users = new HashSet<ApplicationUser>();
        if (emailAddressesInLowerCase != null) {
            for (String emailAddressInLowerCase : emailAddressesInLowerCase) {
                for (ApplicationUser user : this.userResolver.getUsersByEmail(emailAddressInLowerCase)) {
                    String email = user != null && user.getEmailAddress() != null ? user.getEmailAddress().toLowerCase() : null;
                    if (email == null || !emailAddressesInLowerCase.contains(email)) continue;
                    users.add(user);
                    userEmailAddressesInLowerCase.add(email);
                }
            }
            emailAddressesInLowerCase.removeAll(userEmailAddressesInLowerCase);
        }
        return users;
    }

    private AutoReplyParams resolveAutoReplyContexts(Issue issue) {
        return this.autoReplyParamsDao.resolveMailHandlerContext(issue);
    }

    private void sendAutoReply(Issue issue, ApplicationUser user, HashSet<String> senderEmailAddresses, Template template, String comment) throws MessagingException {
        if (template == null) {
            return;
        }
        List recipients = Collections.EMPTY_LIST;
        List copyRecipients = Collections.EMPTY_LIST;
        String senders = StringUtils.join(senderEmailAddresses, (String)",");
        EmailOptions emailOptions = new EmailOptions(this.globalConfiguration);
        EmailDefinitionImpl def = new EmailDefinitionImpl(issue, recipients, copyRecipients, Collections.EMPTY_LIST, emailOptions, "", "", user, senders, "", "", this.authenticationContext.getI18nHelper(), this.globalConfiguration.getEventId(), EmailSource.AUTOREPLY);
        def.setEmailTemplate(template == null ? null : template);
        def.setComment(comment);
        try {
            this.emailSender.sendEmailAsync(def, user);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private boolean saveSenderInField(Message message, Issue issue, ApplicationUser user, AutoReplyParams autoReplyParams, HashSet<String> senderEmailAddresses, Set<String> excludeEmails) {
        String reporterEmail;
        String string = reporterEmail = issue != null && issue.getReporter() != null ? issue.getReporter().getEmailAddress() : "";
        if (autoReplyParams.isUserRecipientsAsWatchers() && senderEmailAddresses.contains(reporterEmail.toLowerCase())) {
            return false;
        }
        boolean fieldChanged = false;
        CollectionUtils.removeAllIgnoreCase(senderEmailAddresses, excludeEmails);
        if (issue instanceof MutableIssue) {
            MutableIssue mutableIssue = (MutableIssue)issue;
            try {
                if (autoReplyParams != null && autoReplyParams.getSenderFieldId() != null && message != null && message.getFrom() != null && !senderEmailAddresses.isEmpty()) {
                    List fields = this.customFieldManager.getCustomFieldObjects((Issue)mutableIssue);
                    for (CustomField cf : fields) {
                        if (!cf.getIdAsLong().equals(autoReplyParams.getSenderFieldId())) continue;
                        String currentValue = (String)mutableIssue.getCustomFieldValue(cf);
                        if (StringUtils.isNotBlank((String)currentValue)) {
                            currentValue = currentValue.toLowerCase();
                            HashSet<String> currentValueAddresses = new HashSet<String>(Arrays.asList(currentValue.split("\\s*,\\s*")));
                            Iterator<String> it = senderEmailAddresses.iterator();
                            while (it.hasNext()) {
                                String senderEmail = it.next();
                                if (!currentValueAddresses.contains(senderEmail.toLowerCase()) && !reporterEmail.equalsIgnoreCase(senderEmail)) continue;
                                it.remove();
                            }
                        }
                        if (senderEmailAddresses.isEmpty()) break;
                        fieldChanged = true;
                        boolean multilineText = cf.getCustomFieldType() instanceof TextAreaCFType;
                        currentValue = StringUtils.isBlank((String)currentValue) ? "" : currentValue;
                        StringBuilder newValue = new StringBuilder(currentValue);
                        for (String senderEmailAddress : senderEmailAddresses) {
                            if (!multilineText && newValue.length() + senderEmailAddress.length() + 1 > 255) break;
                            if (newValue.length() > 0) {
                                newValue.append(",");
                            }
                            newValue.append(senderEmailAddress);
                        }
                        mutableIssue.setCustomFieldValue(cf, (Object)newValue.toString().toLowerCase());
                        break;
                    }
                }
                if (autoReplyParams != null && autoReplyParams.getSenderNameFieldId() != null && message != null && message.getFrom() != null && message.getFrom().length > 0 && message.getFrom()[0] instanceof InternetAddress && StringUtils.isNotBlank((String)((InternetAddress)message.getFrom()[0]).getPersonal())) {
                    String personal = ((InternetAddress)message.getFrom()[0]).getPersonal().toLowerCase();
                    String personalOriginal = ((InternetAddress)message.getFrom()[0]).getPersonal();
                    CustomField senderNameField = this.customFieldManager.getCustomFieldObject(autoReplyParams.getSenderNameFieldId());
                    if (senderNameField != null) {
                        String currentNamesValue = (String)issue.getCustomFieldValue(senderNameField);
                        if (StringUtils.isNotBlank((String)currentNamesValue)) {
                            HashSet<String> currentNames = new HashSet<String>(Arrays.asList(currentNamesValue.toLowerCase().split("\\s*,\\s*")));
                            if (!currentNames.contains(personal)) {
                                currentNamesValue = currentNamesValue + "," + personalOriginal;
                                mutableIssue.setCustomFieldValue(senderNameField, (Object)currentNamesValue);
                            }
                        } else {
                            mutableIssue.setCustomFieldValue(senderNameField, (Object)personalOriginal);
                        }
                    }
                }
            }
            catch (MessagingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return fieldChanged;
    }

    protected boolean saveRecipients(Issue issue, HashSet<String> emailAddresses, AutoReplyParams autoReplyParams, Long fieldId, Set<String> excludeEmails) {
        boolean fieldChanged;
        block6: {
            fieldChanged = false;
            if (issue instanceof MutableIssue) {
                MutableIssue mutableIssue = (MutableIssue)issue;
                HashSet<String> emailAddressesToSave = new HashSet<String>(emailAddresses);
                CollectionUtils.removeAllIgnoreCase(emailAddressesToSave, excludeEmails);
                try {
                    if (autoReplyParams == null || fieldId == null || emailAddressesToSave.isEmpty()) break block6;
                    List fields = this.customFieldManager.getCustomFieldObjects((Issue)mutableIssue);
                    for (CustomField cf : fields) {
                        String currentValue;
                        if (!cf.getIdAsLong().equals(fieldId)) continue;
                        String newValue = currentValue = (String)mutableIssue.getCustomFieldValue(cf);
                        boolean multilineText = cf.getCustomFieldType() instanceof TextAreaCFType;
                        for (String emailAddress : emailAddressesToSave) {
                            String tempValue = StringUtil.merge(newValue, Sets.newHashSet((Object[])new String[]{emailAddress}), ",");
                            if (!multilineText && tempValue.length() > 255) break;
                            newValue = tempValue;
                        }
                        if (newValue != null && !newValue.equalsIgnoreCase(currentValue)) {
                            fieldChanged = true;
                            mutableIssue.setCustomFieldValue(cf, (Object)newValue.toLowerCase());
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return fieldChanged;
    }

    protected String truncateIfExceedingLimits(String value, boolean richText) {
        String truncatedValue = value;
        try {
            Long maxSize = Long.parseLong(this.applicationProperties.getString("jira.text.field.character.limit"));
            if (maxSize != null && maxSize > 0L && truncatedValue != null && (long)truncatedValue.length() > maxSize) {
                truncatedValue = truncatedValue.substring(0, maxSize.intValue());
                if (richText) {
                    if (truncatedValue.endsWith("<")) {
                        truncatedValue = truncatedValue + " ";
                    }
                    truncatedValue = RichTextMailUtils.tidyHtml(truncatedValue);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return truncatedValue;
    }

    private String sanitizeText(String s) {
        if (Boolean.TRUE.equals(this.globalConfiguration.getSanitizeEmails())) {
            return StringUtil.sanitize(s);
        }
        return s;
    }
}

