/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.handler.AbstractMailHandler;
import com.metainf.jira.plugin.emailissue.handler.IssueSupportingMessageHandlerContext;
import com.metainf.jira.plugin.emailissue.handler.RegexSupportingCreateOrCommentHandler;
import com.metainf.jira.plugin.emailissue.handler.ReporterResolvingCreateOrCommentHandler;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;

public class CreateOrCommentWithRegexpHandler
extends AbstractMailHandler {
    private final MessageHandler createHandler;
    private final MessageHandler commentHandler;
    private final IssueLinkManager issueLinkManager;

    public CreateOrCommentWithRegexpHandler(AutoReplyParams mailHandlerContext, IssueLinkManager issueLinkManager, FieldContextProcessor fieldContextProcessor) {
        super(mailHandlerContext, fieldContextProcessor);
        this.issueLinkManager = issueLinkManager;
        this.createHandler = new ReporterResolvingCreateOrCommentHandler(fieldContextProcessor, mailHandlerContext);
        String[] regex = StringUtils.isNotBlank((String)this.mailHandlerContext.getSplitregex()) ? this.mailHandlerContext.getSplitregex().split("\r\n") : null;
        this.commentHandler = regex == null ? new ReporterResolvingCreateOrCommentHandler(fieldContextProcessor, mailHandlerContext) : new RegexSupportingCreateOrCommentHandler(regex, this.mailHandlerContext, fieldContextProcessor);
    }

    @Override
    public void init(Map<String, String> stringStringMap, MessageHandlerErrorCollector messageHandlerErrorCollector) {
        super.init(stringStringMap, messageHandlerErrorCollector);
        this.createHandler.init(stringStringMap, messageHandlerErrorCollector);
        this.commentHandler.init(stringStringMap, messageHandlerErrorCollector);
    }

    @Override
    public boolean handleMessage(Message message, IssueSupportingMessageHandlerContext messageHandlerContext, Issue issue) throws MessagingException {
        if (issue == null) {
            return this.createHandler.handleMessage(message, (MessageHandlerContext)messageHandlerContext);
        }
        return this.commentHandler.handleMessage(message, (MessageHandlerContext)messageHandlerContext);
    }
}

