/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.handler.AbstractMailHandler;
import com.metainf.jira.plugin.emailissue.handler.IssueSupportingMessageHandlerContext;
import com.metainf.jira.plugin.emailissue.handler.RegexSupportingCreateOrCommentHandler;
import com.metainf.jira.plugin.emailissue.handler.ReporterResolvingCreateIssueHandler;
import com.metainf.jira.plugin.emailissue.handler.ReporterResolvingCreateOrCommentHandler;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;

public class CreateOrCommentOrLinkHandler
extends AbstractMailHandler {
    private final MessageHandler createHandler;
    private final MessageHandler commentHandler;
    private final IssueLinkManager issueLinkManager;
    private final IssueSearcher issueSearcher;
    private final IssueLinkTypeManager issueLinkTypeManager;

    public CreateOrCommentOrLinkHandler(AutoReplyParams mailHandlerContext, IssueLinkManager issueLinkManager, IssueSearcher issueSearcher, FieldContextProcessor fieldContextProcessor) {
        super(mailHandlerContext, fieldContextProcessor);
        this.issueLinkManager = issueLinkManager;
        this.createHandler = new ReporterResolvingCreateIssueHandler(fieldContextProcessor, mailHandlerContext);
        this.issueSearcher = issueSearcher;
        this.issueLinkTypeManager = (IssueLinkTypeManager)ComponentAccessor.getComponent(IssueLinkTypeManager.class);
        String[] regex = StringUtils.isNotBlank((String)this.mailHandlerContext.getSplitregex()) ? this.mailHandlerContext.getSplitregex().split("\r\n") : null;
        this.commentHandler = regex == null ? new ReporterResolvingCreateOrCommentHandler(fieldContextProcessor, mailHandlerContext) : new RegexSupportingCreateOrCommentHandler(regex, this.mailHandlerContext, this.fieldContextProcessor);
    }

    @Override
    public void init(Map<String, String> stringStringMap, MessageHandlerErrorCollector messageHandlerErrorCollector) {
        super.init(stringStringMap, messageHandlerErrorCollector);
        this.createHandler.init(stringStringMap, messageHandlerErrorCollector);
        this.commentHandler.init(stringStringMap, messageHandlerErrorCollector);
    }

    @Override
    public boolean handleMessage(Message message, IssueSupportingMessageHandlerContext messageHandlerContext, Issue issue) throws MessagingException {
        if (issue == null) {
            return this.createHandler.handleMessage(message, (MessageHandlerContext)messageHandlerContext);
        }
        if (!this.processingType.isCommentCriteriaEnabled() || StringUtils.isBlank((String)this.mailHandlerContext.getCommentCriteria()) || this.issueSearcher.issueMatchesJQLWithoutReindexing(this.mailHandlerContext.getCommentCriteria(), issue, true)) {
            return this.commentHandler.handleMessage(message, (MessageHandlerContext)messageHandlerContext);
        }
        if (this.processingType.isLinkEnabled() && this.mailHandlerContext.getLinkType() != null && this.mailHandlerContext.getLinkType() > 0L && this.issueLinkTypeManager.getIssueLinkType(this.mailHandlerContext.getLinkType()) != null) {
            Issue issueCreated;
            boolean result = this.createHandler.handleMessage(message, (MessageHandlerContext)messageHandlerContext);
            if (result && (issueCreated = messageHandlerContext.getIssueAffected()) != null && issue != null) {
                try {
                    this.issueLinkManager.createIssueLink(issueCreated.getId(), issue.getId(), this.mailHandlerContext.getLinkType(), Long.valueOf(10L), issueCreated.getReporter());
                }
                catch (CreateException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return result;
        }
        return this.createHandler.handleMessage(message, (MessageHandlerContext)messageHandlerContext);
    }
}

