/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.handler.AbstractMailHandler;
import com.metainf.jira.plugin.emailissue.handler.IssueSupportingMessageHandlerContext;
import com.metainf.jira.plugin.emailissue.handler.JETIMailHandler;
import com.metainf.jira.plugin.emailissue.handler.ReporterResolvingCreateIssueHandler;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;

public class CreateAndLinkHandler
extends AbstractMailHandler
implements JETIMailHandler {
    private final MessageHandler delegatingHandler;
    private final IssueLinkManager issueLinkManager;
    private final IssueLinkTypeManager issueLinkTypeManager = (IssueLinkTypeManager)ComponentAccessor.getComponent(IssueLinkTypeManager.class);

    public CreateAndLinkHandler(AutoReplyParams mailHandlerContext, IssueLinkManager issueLinkManager, FieldContextProcessor fieldContextProcessor) {
        super(mailHandlerContext, fieldContextProcessor);
        this.issueLinkManager = issueLinkManager;
        this.delegatingHandler = new ReporterResolvingCreateIssueHandler(fieldContextProcessor, mailHandlerContext);
    }

    @Override
    public void init(Map<String, String> stringStringMap, MessageHandlerErrorCollector messageHandlerErrorCollector) {
        super.init(stringStringMap, messageHandlerErrorCollector);
        this.delegatingHandler.init(stringStringMap, messageHandlerErrorCollector);
    }

    @Override
    public boolean handleMessage(Message message, IssueSupportingMessageHandlerContext messageHandlerContext, Issue issue) throws MessagingException {
        if (issue == null) {
            return this.delegatingHandler.handleMessage(message, (MessageHandlerContext)messageHandlerContext);
        }
        if (this.processingType.isLinkEnabled() && this.mailHandlerContext.getLinkType() != null && this.mailHandlerContext.getLinkType() > 0L && this.issueLinkTypeManager.getIssueLinkType(this.mailHandlerContext.getLinkType()) != null) {
            Issue issueCreated;
            boolean result = this.delegatingHandler.handleMessage(message, (MessageHandlerContext)messageHandlerContext);
            if (result && (issueCreated = messageHandlerContext.getIssueAffected()) != null && issue != null) {
                try {
                    this.issueLinkManager.createIssueLink(issueCreated.getId(), issue.getId(), this.mailHandlerContext.getLinkType(), Long.valueOf(10L), issueCreated.getReporter());
                }
                catch (CreateException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return result;
        }
        return this.delegatingHandler.handleMessage(message, (MessageHandlerContext)messageHandlerContext);
    }
}

