/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.handler.AbstractMailHandler;
import com.metainf.jira.plugin.emailissue.handler.IssueSupportingMessageHandlerContext;
import com.metainf.jira.plugin.emailissue.handler.JETIMailHandler;
import com.metainf.jira.plugin.emailissue.handler.RegexSupportingCreateOrCommentHandler;
import com.metainf.jira.plugin.emailissue.handler.ReporterResolvingCreateOrCommentHandler;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;

public class CommentWithRegexpHandler
extends AbstractMailHandler
implements JETIMailHandler {
    private final MessageHandler delegatingHandler;

    public CommentWithRegexpHandler(AutoReplyParams mailHandlerContext, FieldContextProcessor fieldContextProcessor) {
        super(mailHandlerContext, fieldContextProcessor);
        String[] regex = StringUtils.isNotBlank((String)this.mailHandlerContext.getSplitregex()) ? this.mailHandlerContext.getSplitregex().split("\r\n") : null;
        this.delegatingHandler = regex == null ? new ReporterResolvingCreateOrCommentHandler(fieldContextProcessor, mailHandlerContext) : new RegexSupportingCreateOrCommentHandler(regex, this.mailHandlerContext, fieldContextProcessor);
    }

    @Override
    public void init(Map<String, String> stringStringMap, MessageHandlerErrorCollector messageHandlerErrorCollector) {
        super.init(stringStringMap, messageHandlerErrorCollector);
        this.delegatingHandler.init(stringStringMap, messageHandlerErrorCollector);
    }

    @Override
    public boolean handleMessage(Message message, IssueSupportingMessageHandlerContext messageHandlerContext, Issue issue) throws MessagingException {
        if (issue != null) {
            return this.delegatingHandler.handleMessage(message, (MessageHandlerContext)messageHandlerContext);
        }
        return false;
    }
}

