/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.handler;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.atlassian.jira.service.util.handler.MessageUserProcessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.mail.MailUtils;
import com.metainf.jira.plugin.emailissue.entity.AutoReplyParams;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.handler.IssueSupportingMessageHandlerContext;
import com.metainf.jira.plugin.emailissue.handler.JETIMailHandler;
import com.metainf.jira.plugin.emailissue.handler.MailHandlerContext;
import com.metainf.jira.plugin.emailissue.mail.EmailBean;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractMailHandler
implements MessageHandler,
JETIMailHandler {
    protected Logger logger = Logger.getLogger(this.getClass());
    protected final AutoReplyParams mailHandlerContext;
    protected final AutoReplyParams.ProcessingType processingType;
    protected final FieldContextProcessor fieldContextProcessor;
    private final EventTypeManager eventTypeManager = ComponentAccessor.getEventTypeManager();
    private final IssueEventManager issueEventManager = ComponentAccessor.getIssueEventManager();
    private final UserKeyService userKeyService = ComponentAccessor.getUserKeyService();
    protected Map<String, String> params;
    protected MessageHandlerErrorCollector errorCollector;
    protected String reporteruserName;

    protected AbstractMailHandler(AutoReplyParams mailHandlerContext, FieldContextProcessor fieldContextProcessor) {
        this.mailHandlerContext = mailHandlerContext;
        this.fieldContextProcessor = fieldContextProcessor;
        this.processingType = mailHandlerContext.getProcessingStrategy() == null ? AutoReplyParams.ProcessingType.CREATE_OR_COMMENT : mailHandlerContext.getProcessingStrategy();
    }

    public AutoReplyParams getMailHandlerContext() {
        return this.mailHandlerContext;
    }

    public AutoReplyParams.ProcessingType getProcessingType() {
        return this.processingType;
    }

    protected Issue getIssueFromMessage(Message message) throws MessagingException {
        Object issue = null;
        String subject = message.getSubject();
        issue = ServiceUtils.findIssueObjectInString((String)subject);
        if (issue == null) {
            this.logger.debug((Object)("Issue Key not found in subject '" + subject + "'. Inspecting the in-reply-to message ID."));
            issue = MailHandlerContext.currentContext().isPresent() && Boolean.TRUE.equals(MailHandlerContext.currentContext().get().getIgnoreIssueInHeader()) ? null : ComponentAccessor.getMailThreadManager().getAssociatedIssueObject(message);
        }
        if (issue == null && this.mailHandlerContext != null && Boolean.TRUE.equals(this.mailHandlerContext.getOverrideIssueLookup())) {
            issue = this.lookupIssueUponFieldRules(message);
        }
        return issue;
    }

    protected Issue lookupIssueUponFieldRules(Message message) throws MessagingException {
        Issue issue = null;
        ApplicationUser user = null;
        if (StringUtils.isNotBlank((String)this.mailHandlerContext.getMailHandlerUser())) {
            user = ApplicationUsers.byKey((String)this.mailHandlerContext.getMailHandlerUser());
        }
        if (user == null) {
            user = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
        }
        if (user == null) {
            ApplicationUser reporter = this.getMessageUserProcessor().getAuthorFromSender(message);
            if (reporter == null) {
                reporter = this.getDefaultReporter();
            }
            user = reporter;
        }
        issue = this.fieldContextProcessor.lookupIssue(this.mailHandlerContext.getProjectId(), this.mailHandlerContext.getIssueTypeId(), new EmailBean(message), user);
        return issue;
    }

    protected MessageUserProcessor getMessageUserProcessor() {
        return (MessageUserProcessor)ComponentAccessor.getComponent(MessageUserProcessor.class);
    }

    public final boolean handleMessage(Message message, MessageHandlerContext messageHandlerContext) throws MessagingException {
        boolean emailProcessed = false;
        try {
            Issue issue = this.getIssueFromMessage(message);
            IssueSupportingMessageHandlerContext mailHandlerContext = messageHandlerContext instanceof IssueSupportingMessageHandlerContext ? (IssueSupportingMessageHandlerContext)messageHandlerContext : new IssueSupportingMessageHandlerContext(messageHandlerContext, message);
            emailProcessed = this.handleMessage(message, mailHandlerContext, issue);
            if (emailProcessed && mailHandlerContext.getIssueAffected() != null) {
                this.fireEvent(this.mailHandlerContext, mailHandlerContext.getIssueAffected());
            }
            return emailProcessed;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error occured, handler continuous: " + e.getMessage()), (Throwable)e);
            throw new MessagingException(e.getLocalizedMessage(), e);
        }
    }

    protected abstract boolean handleMessage(Message var1, IssueSupportingMessageHandlerContext var2, Issue var3) throws MessagingException;

    private void fireEvent(AutoReplyParams autoReplyParams, Issue issue) {
        ApplicationUser actingUser = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
        try {
            EventType eventType;
            EventType eventType2 = eventType = autoReplyParams.getEventOnEmail() == null ? null : this.eventTypeManager.getEventType(autoReplyParams.getEventOnEmail());
            if (eventType != null && issue != null) {
                IssueEventBundleFactory bundleFactory = (IssueEventBundleFactory)ComponentAccessor.getComponent(IssueEventBundleFactory.class);
                IssueEventBundle eventBundle = bundleFactory.wrapInBundle(new IssueEvent(issue, new HashMap(), actingUser == null ? issue.getReporter() : actingUser, eventType.getId(), true));
                this.issueEventManager.dispatchEvent(eventBundle);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected String getEmailBody(Message message) throws MessagingException {
        return MailUtils.getBody((Message)message);
    }

    protected ApplicationUser getDefaultReporter() {
        String reporteruserKey = this.params.get("reporteruserkey");
        ApplicationUser reporter = reporteruserKey == null ? null : ApplicationUsers.byKey((String)reporteruserKey);
        return reporter;
    }

    protected ApplicationUser getDefaultReporterUser() {
        String reporteruserKey = this.params.get("reporteruserkey");
        ApplicationUser reporter = reporteruserKey == null ? null : ApplicationUsers.byKey((String)reporteruserKey);
        return reporter;
    }

    public void init(Map<String, String> params, MessageHandlerErrorCollector errorCollector) {
        this.params = params;
        this.errorCollector = errorCollector;
        if (params.containsKey("reporterusername")) {
            this.reporteruserName = params.get("reporterusername");
        }
        if (params.containsKey("reporteruserkey")) {
            String reporterUserKey = params.get("reporteruserkey");
            this.reporteruserName = this.userKeyService.getUsernameForKey(reporterUserKey);
        }
    }
}

