/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.field.CustomFieldSetter;

public class UserSetter
extends CustomFieldSetter {
    protected final UserResolver userResolver;
    protected final UserManager userManager;

    protected UserSetter(CustomFieldManager customFieldManager, UserResolver userResolver, UserManager userManager) {
        super(customFieldManager);
        this.userResolver = userResolver;
        this.userManager = userManager;
    }

    @Override
    protected void setValueInIssue(MutableIssue issue, CustomField customField, String value) {
        ApplicationUser user = this.getApplicationUser(value);
        if (user != null && customField != null) {
            issue.setCustomFieldValue(customField, (Object)user);
        }
    }

    protected ApplicationUser getApplicationUser(String value) {
        ApplicationUser user = null;
        if (this.userResolver.isUser(value)) {
            user = this.userManager.getUserByName(value);
        } else if (this.userResolver.isEmailAddress(value)) {
            user = this.userResolver.getFirstApplicationUserForEmailAddress(value);
        } else if (this.userResolver.isExtendedEmailAddress(value)) {
            String emailAddress = this.userResolver.getEmailAddressFromExtendedAddress(value);
            user = this.userResolver.getFirstApplicationUserForEmailAddress(emailAddress);
        } else {
            user = this.userResolver.getFirstApplicationUserForFullName(value);
        }
        return user;
    }
}

