/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.metainf.jira.plugin.emailissue.field.CustomFieldSetter;
import org.apache.commons.lang3.StringUtils;

public class TextSetter
extends CustomFieldSetter {
    private final ApplicationProperties applicationProperties;

    protected TextSetter(CustomFieldManager customFieldManager, ApplicationProperties applicationProperties) {
        super(customFieldManager);
        this.applicationProperties = applicationProperties;
    }

    @Override
    protected void setValueInIssue(MutableIssue issue, CustomField field, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = this.truncateIfNeeded(value);
            issue.setCustomFieldValue(field, (Object)value);
        }
    }

    @Override
    protected String truncateIfNeeded(String value) {
        String truncatedValue = value;
        try {
            Long maxSize = Long.parseLong(this.applicationProperties.getString("jira.text.field.character.limit"));
            if (maxSize != null && maxSize > 0L && truncatedValue != null && (long)truncatedValue.length() > maxSize) {
                truncatedValue = truncatedValue.substring(0, maxSize.intValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return truncatedValue;
    }
}

