/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.metainf.jira.plugin.emailissue.desk.CustomerRequestType;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.field.CustomFieldSetter;
import java.util.Collection;

public class ServiceDeskRequestTypeSetter
extends CustomFieldSetter {
    private final ServiceDeskManager serviceDeskManager;

    protected ServiceDeskRequestTypeSetter(CustomFieldManager customFieldManager, ServiceDeskManager serviceDeskManager) {
        super(customFieldManager);
        this.serviceDeskManager = serviceDeskManager;
    }

    @Override
    protected void setValueInIssue(MutableIssue issue, CustomField field, String customerRequestTypeName) {
        Object value;
        CustomerRequestType requestType;
        if (this.isServiceDeskIssue(issue) && (requestType = this.getRequestType(customerRequestTypeName, issue)) != null && (value = field.getCustomFieldType().getSingularObjectFromString(requestType.getKey())) != null) {
            issue.setCustomFieldValue(field, value);
        }
    }

    private CustomerRequestType getRequestType(String customerRequestTypeName, MutableIssue issue) {
        CustomerRequestType customerRequestType = null;
        String customerRequestTypeNameToMatch = customerRequestTypeName;
        Collection<CustomerRequestType> types = this.serviceDeskManager.getCustomerRequestTypesForIssue((Issue)issue);
        for (CustomerRequestType requestType : types) {
            if (!requestType.getName().equalsIgnoreCase(customerRequestTypeNameToMatch)) continue;
            customerRequestType = requestType;
            break;
        }
        return customerRequestType;
    }

    private boolean isServiceDeskIssue(MutableIssue issue) {
        return this.serviceDeskManager.isServiceDeskProject(issue.getProjectId());
    }
}

