/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.field.AbstractIssueFieldSetter;
import org.apache.commons.lang3.StringUtils;

public class ReporterSetter
extends AbstractIssueFieldSetter {
    private final UserResolver userResolver;
    private final UserManager userManager;

    public ReporterSetter(UserResolver userResolver, UserManager userManager) {
        this.userResolver = userResolver;
        this.userManager = userManager;
    }

    @Override
    public void write(MutableIssue issue, String field, String value) {
        if (issue != null && StringUtils.isNotBlank((CharSequence)value)) {
            ApplicationUser user = null;
            if (this.userResolver.isUser(value)) {
                user = this.userManager.getUserByName(value);
            } else if (this.userResolver.isEmailAddress(value)) {
                user = this.userResolver.getFirstApplicationUserForEmailAddress(value);
            } else if (this.userResolver.isExtendedEmailAddress(value)) {
                String emailAddress = this.userResolver.getEmailAddressFromExtendedAddress(value);
                user = this.userResolver.getFirstApplicationUserForEmailAddress(emailAddress);
            }
            if (user != null) {
                issue.setReporter(user);
            }
        }
    }
}

