/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.metainf.jira.plugin.emailissue.field.AbstractIssueFieldSetter;
import org.apache.commons.lang3.StringUtils;

public class ProjectSetter
extends AbstractIssueFieldSetter {
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;

    public ProjectSetter(PermissionManager permissionManager, ProjectManager projectManager) {
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
    }

    @Override
    public void write(MutableIssue issue, String field, String value) {
        Project project;
        if (issue != null && StringUtils.isNotBlank((CharSequence)value) && (project = this.getProject(value)) != null && this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, issue.getReporterUser())) {
            issue.setProjectObject(project);
        }
    }

    private Project getProject(String value) {
        Project project = this.projectManager.getProjectObjByKeyIgnoreCase(value);
        if (project == null && (project = this.projectManager.getProjectObjByName(value)) == null) {
            for (Project p : this.projectManager.getProjectObjects()) {
                if (!p.getKey().equalsIgnoreCase(value) && !p.getName().equalsIgnoreCase(value)) continue;
                project = p;
                break;
            }
        }
        return project;
    }
}

