/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.MutableIssue;
import com.metainf.jira.plugin.emailissue.field.AbstractIssueFieldSetter;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class OriginalEstimateSetter
extends AbstractIssueFieldSetter {
    private final Logger logger = Logger.getLogger(this.getClass());

    @Override
    public void write(MutableIssue issue, String field, String value) {
        if (issue != null && StringUtils.isNotBlank((CharSequence)value)) {
            try {
                NumberFormat nf = NumberFormat.getIntegerInstance();
                Number number = nf.parse(value);
                if (number != null) {
                    this.storeInIssue(issue, number.longValue());
                }
            }
            catch (ParseException e) {
                this.logger.warn((Object)("Setting esitmate failed: " + e.getMessage()));
            }
        }
    }

    protected void storeInIssue(MutableIssue issue, long l) {
        issue.setOriginalEstimate(Long.valueOf(l));
    }
}

