/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.metainf.jira.plugin.emailissue.field.CustomFieldSetter;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.log4j.Logger;

public class NumberSetter
extends CustomFieldSetter {
    private final Logger logger = Logger.getLogger(this.getClass());

    protected NumberSetter(CustomFieldManager customFieldManager) {
        super(customFieldManager);
    }

    @Override
    protected void setValueInIssue(MutableIssue issue, CustomField field, String value) {
        try {
            BigDecimal newValue;
            NumberFormat nf = NumberFormat.getIntegerInstance();
            Double currentValue = (Double)issue.getCustomFieldValue(field);
            BigDecimal bigDecimal = newValue = currentValue == null ? BigDecimal.valueOf(0L) : BigDecimal.valueOf(currentValue);
            if (value.startsWith("+")) {
                Number number = nf.parse(value.substring(1));
                newValue = newValue.add(BigDecimal.valueOf(number.doubleValue()));
            } else if (value.startsWith("-")) {
                Number number = nf.parse(value.substring(1));
                newValue = newValue.subtract(BigDecimal.valueOf(number.doubleValue()));
            } else {
                Number number = nf.parse(value);
                newValue = BigDecimal.valueOf(number.doubleValue());
            }
            issue.setCustomFieldValue(field, (Object)new Double(newValue.doubleValue()));
        }
        catch (ParseException e) {
            this.logger.warn((Object)("Setting number field failed: " + e.getMessage()), (Throwable)e);
        }
    }
}

