/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.metainf.jira.plugin.emailissue.field.SelectSetter;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class MultiSelectSetter
extends SelectSetter {
    protected MultiSelectSetter(CustomFieldManager customFieldManager, OptionsManager optionsManager) {
        super(customFieldManager, optionsManager);
    }

    @Override
    protected void setValueInIssue(MutableIssue issue, CustomField field, String value) {
        Collection<Option> options = this.getOptions(issue, field, value);
        if (options != null && !options.isEmpty()) {
            HashSet<Option> fieldValue = (HashSet<Option>)issue.getCustomFieldValue(field);
            if (fieldValue == null) {
                fieldValue = new HashSet<Option>();
            }
            for (Option o : options) {
                fieldValue.add(o);
            }
            issue.setCustomFieldValue(field, fieldValue);
        }
    }

    protected Collection<Option> getOptions(MutableIssue issue, CustomField field, String value) {
        Options currentOptionsInField;
        HashSet<String> optionValues = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            for (String v : value.split(",")) {
                optionValues.add(v.trim().toLowerCase());
            }
        }
        HashSet<Option> options = new HashSet<Option>();
        FieldConfig fc = field.getRelevantConfig((Issue)issue);
        if (fc != null && (currentOptionsInField = this.optionsManager.getOptions(fc)) != null && !currentOptionsInField.isEmpty()) {
            for (Option option : currentOptionsInField) {
                if (!optionValues.contains(option.getValue().toLowerCase())) continue;
                options.add(option);
            }
        }
        return options;
    }
}

