/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelManager;
import com.metainf.jira.plugin.emailissue.field.AbstractIssueFieldSetter;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class LabelsSetter
extends AbstractIssueFieldSetter {
    private final LabelManager labelManager;

    public LabelsSetter(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    @Override
    public void write(MutableIssue issue, String field, String value) {
        if (issue != null && issue.getId() != null && StringUtils.isNotBlank((CharSequence)value)) {
            Set currentLabels = issue.getLabels();
            Set<String> labelsToAdd = this.getLabelsToAdd(value);
            for (String labelToAdd : labelsToAdd) {
                if (this.labelNotExists(currentLabels, labelToAdd)) continue;
                this.labelManager.addLabel(issue.getReporter(), issue.getId(), labelToAdd, false);
            }
        }
    }

    private Set<String> getLabelsToAdd(String value) {
        HashSet<String> labels = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            for (String v : value.split(",")) {
                labels.add(v.trim().replaceAll(" ", "").toLowerCase());
            }
        }
        return labels;
    }

    private boolean labelNotExists(Set<Label> labels, String value) {
        for (Label l : labels) {
            if (!value.equalsIgnoreCase(l.getLabel())) continue;
            return true;
        }
        return false;
    }
}

