/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.metainf.jira.plugin.emailissue.field.AbstractIssueFieldSetter;
import org.apache.commons.lang3.StringUtils;

public class IssueTypeSetter
extends AbstractIssueFieldSetter {
    private final IssueTypeSchemeManager issueTypeSchemeManager;

    public IssueTypeSetter(IssueTypeSchemeManager issueTypeSchemeManager) {
        this.issueTypeSchemeManager = issueTypeSchemeManager;
    }

    @Override
    public void write(MutableIssue issue, String field, String value) {
        IssueType issueType;
        if (issue != null && StringUtils.isNotBlank((CharSequence)value) && !issue.getIssueType().getName().equalsIgnoreCase(value) && (issueType = this.getIssueTypeByName(issue, value)) != null) {
            issue.setIssueTypeObject(issueType);
        }
    }

    private IssueType getIssueTypeByName(MutableIssue issue, String value) {
        for (IssueType it : this.issueTypeSchemeManager.getIssueTypesForProject(issue.getProjectObject())) {
            if (!it.getName().equalsIgnoreCase(value)) continue;
            return it;
        }
        return null;
    }
}

