/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.metainf.jira.plugin.emailissue.field.AbstractIssueFieldSetter;

public class IssueSecuritySetter
extends AbstractIssueFieldSetter {
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;

    public IssueSecuritySetter(IssueSecurityLevelManager issueSecurityLevelManager, IssueSecuritySchemeManager issueSecuritySchemeManager) {
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
    }

    @Override
    public void write(MutableIssue issue, String field, String value) {
        IssueSecurityLevel issueSecurityLevel = this.findSecurityLevel(issue, value);
        if (issueSecurityLevel != null) {
            issue.setSecurityLevelId(issueSecurityLevel.getId());
        }
    }

    private IssueSecurityLevel findSecurityLevel(MutableIssue issue, String value) {
        Long schemeId = this.issueSecuritySchemeManager.getSchemeIdFor(issue.getProjectObject());
        if (schemeId != null) {
            for (IssueSecurityLevel issueSecurityLevel : this.issueSecurityLevelManager.getIssueSecurityLevels(schemeId.longValue())) {
                if (!value.equalsIgnoreCase(issueSecurityLevel.getName())) continue;
                return issueSecurityLevel;
            }
        }
        return null;
    }
}

