/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.MultiGroupCFType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.NumberCFType;
import com.atlassian.jira.issue.customfields.impl.RenderableTextCFType;
import com.atlassian.jira.issue.customfields.impl.SelectCFType;
import com.atlassian.jira.issue.customfields.impl.TextAreaCFType;
import com.atlassian.jira.issue.customfields.impl.UserCFType;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.action.config.IssueField;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.entity.FieldContext;
import com.metainf.jira.plugin.emailissue.entity.FieldContextDao;
import com.metainf.jira.plugin.emailissue.entity.FieldRule;
import com.metainf.jira.plugin.emailissue.field.AffectedVersionsSetter;
import com.metainf.jira.plugin.emailissue.field.AssigneeSetter;
import com.metainf.jira.plugin.emailissue.field.CascadeSelectSetter;
import com.metainf.jira.plugin.emailissue.field.ComponentsSetter;
import com.metainf.jira.plugin.emailissue.field.DateSetter;
import com.metainf.jira.plugin.emailissue.field.DescriptionSetter;
import com.metainf.jira.plugin.emailissue.field.DuedateSetter;
import com.metainf.jira.plugin.emailissue.field.EmailFilterAction;
import com.metainf.jira.plugin.emailissue.field.EnvironmentSetter;
import com.metainf.jira.plugin.emailissue.field.EpicLinkSetter;
import com.metainf.jira.plugin.emailissue.field.FieldContextProcessor;
import com.metainf.jira.plugin.emailissue.field.FixVersionsSetter;
import com.metainf.jira.plugin.emailissue.field.GroupSetter;
import com.metainf.jira.plugin.emailissue.field.IssueFieldSetter;
import com.metainf.jira.plugin.emailissue.field.IssueSecuritySetter;
import com.metainf.jira.plugin.emailissue.field.IssueTypeSetter;
import com.metainf.jira.plugin.emailissue.field.LabelsFieldSetter;
import com.metainf.jira.plugin.emailissue.field.LabelsSetter;
import com.metainf.jira.plugin.emailissue.field.MultiSelectSetter;
import com.metainf.jira.plugin.emailissue.field.MultiUserSetter;
import com.metainf.jira.plugin.emailissue.field.NumberSetter;
import com.metainf.jira.plugin.emailissue.field.OriginalEstimateSetter;
import com.metainf.jira.plugin.emailissue.field.PrioritySetter;
import com.metainf.jira.plugin.emailissue.field.ProjectSetter;
import com.metainf.jira.plugin.emailissue.field.ReporterSetter;
import com.metainf.jira.plugin.emailissue.field.SelectSetter;
import com.metainf.jira.plugin.emailissue.field.ServiceDeskRequestTypeSetter;
import com.metainf.jira.plugin.emailissue.field.SummarySetter;
import com.metainf.jira.plugin.emailissue.field.TextSetter;
import com.metainf.jira.plugin.emailissue.field.UserSetter;
import com.metainf.jira.plugin.emailissue.field.ValueParser;
import com.metainf.jira.plugin.emailissue.mail.EmailBean;
import com.metainf.jira.plugin.emailissue.mail.EmailForwarder;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import com.metainf.jira.plugin.emailissue.template.TemplateRenderer;
import com.metainf.jira.plugin.emailissue.util.CustomFieldUtil;
import com.metainf.jira.plugin.emailissue.workflow.IssueTransitioner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FieldContextProcessorImpl
implements FieldContextProcessor {
    private Logger logger = Logger.getLogger(this.getClass());
    private String[] JQL_CHARACTERS_TO_ESCAPE = "+,&,|,!,(,),{,},[,],^,~,*,?,\\,:".split(",");
    private final Map<String, IssueFieldSetter> issueFieldSetters;
    private final Map<String, IssueFieldSetter> customFieldSetters;
    private final CustomFieldManager customFieldManager;
    private final IssueSearcher issueSearcher;
    private final ProjectManager projectManager;
    private final IssueTypeManager issueTypeManager;
    private final FieldContextDao fieldContextDao;
    private final IssueManager issueManager;
    private final TemplateRenderer templateRenderer;
    private final com.atlassian.sal.api.ApplicationProperties applicationProperties;
    private final ApplicationProperties jiraApplicationProperties;
    private final IssueTransitioner issueTransitioner;
    private final LabelManager labelManager;

    public FieldContextProcessorImpl(IssueTypeSchemeManager issueTypeSchemeManager, PermissionManager permissionManager, ProjectManager projectManager, UserResolver userResolver, UserManager userManager, PriorityManager priorityManager, CustomFieldManager customFieldManager, OptionsManager optionsManager, IssueSearcher issueSearcher, ProjectManager projectManager1, IssueTypeManager issueTypeManager1, FieldContextDao fieldContextDao, IssueManager issueManager, TemplateRenderer templateRenderer, com.atlassian.sal.api.ApplicationProperties applicationProperties, IssueTransitioner issueTransitioner, LabelManager labelManager, ApplicationProperties jiraApplicationProperties, ServiceDeskManager serviceDeskManager, IssueSecurityLevelManager issueSecurityLevelManager, IssueSecuritySchemeManager issueSecuritySchemeManager) {
        this.customFieldManager = customFieldManager;
        this.issueSearcher = issueSearcher;
        this.projectManager = projectManager1;
        this.issueTypeManager = issueTypeManager1;
        this.fieldContextDao = fieldContextDao;
        this.issueManager = issueManager;
        this.templateRenderer = templateRenderer;
        this.applicationProperties = applicationProperties;
        this.issueTransitioner = issueTransitioner;
        this.labelManager = labelManager;
        this.jiraApplicationProperties = jiraApplicationProperties;
        this.issueFieldSetters = new HashMap<String, IssueFieldSetter>();
        this.issueFieldSetters.put(IssueField.AFFECTED_VERSIONS.getId(), new AffectedVersionsSetter());
        this.issueFieldSetters.put(IssueField.ASSIGNEE.getId(), new AssigneeSetter(userResolver, userManager));
        this.issueFieldSetters.put(IssueField.COMPONENTS.getId(), new ComponentsSetter());
        this.issueFieldSetters.put(IssueField.DESCRIPTION.getId(), new DescriptionSetter(jiraApplicationProperties));
        this.issueFieldSetters.put(IssueField.DUEDATE.getId(), new DuedateSetter(permissionManager));
        this.issueFieldSetters.put(IssueField.ENVIRONMENT.getId(), new EnvironmentSetter(jiraApplicationProperties));
        this.issueFieldSetters.put(IssueField.FIX_VERSIONS.getId(), new FixVersionsSetter());
        this.issueFieldSetters.put(IssueField.ISSUETYPE.getId(), new IssueTypeSetter(issueTypeSchemeManager));
        this.issueFieldSetters.put(IssueField.LABELS.getId(), new LabelsSetter(this.labelManager));
        this.issueFieldSetters.put(IssueField.ORIGINAL_ESTIMATE.getId(), new OriginalEstimateSetter());
        this.issueFieldSetters.put(IssueField.PRIORITY.getId(), new PrioritySetter(priorityManager));
        this.issueFieldSetters.put(IssueField.PROJECT.getId(), new ProjectSetter(permissionManager, projectManager));
        this.issueFieldSetters.put(IssueField.REPORTER.getId(), new ReporterSetter(userResolver, userManager));
        this.issueFieldSetters.put(IssueField.SUMMARY.getId(), new SummarySetter());
        this.issueFieldSetters.put(IssueField.SECURITY_LEVEL.getId(), new IssueSecuritySetter(issueSecurityLevelManager, issueSecuritySchemeManager));
        this.customFieldSetters = new HashMap<String, IssueFieldSetter>();
        this.customFieldSetters.put(UserCFType.class.getName(), new UserSetter(customFieldManager, userResolver, userManager));
        this.customFieldSetters.put(MultiUserCFType.class.getName(), new MultiUserSetter(customFieldManager, userResolver, userManager));
        this.customFieldSetters.put(MultiGroupCFType.class.getName(), new GroupSetter(customFieldManager, userManager));
        this.customFieldSetters.put(RenderableTextCFType.class.getName(), new TextSetter(customFieldManager, jiraApplicationProperties));
        this.customFieldSetters.put(TextAreaCFType.class.getName(), new TextSetter(customFieldManager, jiraApplicationProperties));
        this.customFieldSetters.put(SelectCFType.class.getName(), new SelectSetter(customFieldManager, optionsManager));
        this.customFieldSetters.put(CascadingSelectCFType.class.getName(), new CascadeSelectSetter(customFieldManager, optionsManager));
        this.customFieldSetters.put(MultiSelectCFType.class.getName(), new MultiSelectSetter(customFieldManager, optionsManager));
        this.customFieldSetters.put(NumberCFType.class.getName(), new NumberSetter(customFieldManager));
        this.customFieldSetters.put(DateCFType.class.getName(), new DateSetter(customFieldManager));
        this.customFieldSetters.put(DateTimeCFType.class.getName(), new DateSetter(customFieldManager));
        this.customFieldSetters.put("com.atlassian.greenhopper.customfield.epiclink.EpicLinkCFType", new EpicLinkSetter(customFieldManager, issueManager));
        this.customFieldSetters.put(LabelsCFType.class.getName(), new LabelsFieldSetter(this.labelManager, this.customFieldManager));
        this.customFieldSetters.put("com.atlassian.servicedesk.internal.customfields.origin.VpOriginCFType", new ServiceDeskRequestTypeSetter(customFieldManager, serviceDeskManager));
    }

    @Override
    public Map<FieldRule, String> test(FieldContext fieldContext, String expressionTest) {
        HashMap<FieldRule, String> testResult = null;
        if (StringUtils.isNotBlank((String)expressionTest) && fieldContext != null) {
            testResult = new HashMap<FieldRule, String>();
            for (FieldRule rule : fieldContext.getFields()) {
                String value = null;
                try {
                    value = this.extractValue(rule, new String[]{expressionTest}, null);
                }
                catch (Exception e) {
                    value = "Regexp Syntax Error: " + e.getMessage();
                }
                testResult.put(rule, value == null ? "Not matching" : value);
            }
        }
        return testResult;
    }

    private boolean isMatchingRule(FieldRule rule, String[] expressions) {
        boolean isMatching = false;
        if (StringUtils.isNotBlank((String)rule.getRegexp()) && expressions != null && expressions.length > 0) {
            String expressionTest;
            Matcher matcher;
            Pattern pattern = Pattern.compile(rule.getRegexp());
            String[] stringArray = expressions;
            int n = stringArray.length;
            for (int i = 0; i < n && !(isMatching = (matcher = pattern.matcher(expressionTest = stringArray[i])).find()); ++i) {
            }
        }
        return isMatching;
    }

    private String extractValue(FieldRule rule, String[] expressions, Issue issue) {
        String value = null;
        if (StringUtils.isNotBlank((String)rule.getRegexp()) && expressions != null && expressions.length > 0) {
            Pattern pattern = Pattern.compile(rule.getRegexp());
            for (String expressionTest : expressions) {
                Matcher matcher = pattern.matcher(expressionTest);
                if (!matcher.find()) continue;
                if (rule.isValueFromCaptureGroup()) {
                    if (rule.getGroup() == 0) {
                        value = matcher.group();
                        break;
                    }
                    value = matcher.groupCount() >= rule.getGroup() ? matcher.group(rule.getGroup()) : matcher.group();
                    break;
                }
                value = this.resolveManualValue(rule.getValue(), matcher, issue);
                break;
            }
        }
        return value;
    }

    private String resolveManualValue(String value, Matcher matcher, Issue issue) {
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        contextParams.put("issue", issue);
        contextParams.put("parser", new ValueParser());
        if (value != null && matcher != null) {
            for (int i = 0; i <= 10 && i <= matcher.groupCount(); ++i) {
                String pattern = "group" + i;
                contextParams.put(pattern, i == 0 ? matcher.group() : matcher.group(i));
            }
            value = this.templateRenderer.renderTextContent(value, this.applicationProperties.getBaseUrl(), contextParams);
        }
        return value;
    }

    @Override
    public boolean initializeIssueFields(FieldContext fieldContext, MutableIssue mutableIssue, EmailBean email, FieldRule.FieldRuleType fieldRuleType) {
        boolean issueModified = false;
        HashSet<String> fieldsAlreadyMatched = new HashSet<String>();
        if (fieldContext != null && mutableIssue != null && email != null) {
            ArrayList<FieldRule> fieldRules = new ArrayList<FieldRule>(Arrays.asList(fieldContext.getFields()));
            Collections.sort(fieldRules, new FieldRule.EntityComparator());
            for (FieldRule fieldRule : fieldRules) {
                this.logger.info((Object)("Initializing field: " + fieldRule.getFieldId() + ", " + fieldRule.getRegexp()));
                try {
                    String value;
                    IssueField issueField;
                    if (fieldsAlreadyMatched.contains(fieldRule.getFieldId()) || Boolean.TRUE.equals(fieldRule.isIssueLookupRule()) || FieldRule.FieldRuleType.LOOKUP == fieldRule.getFieldRuleType() || fieldRule.getFieldRuleType() == null && fieldRuleType != FieldRule.FieldRuleType.SET || fieldRule.getFieldRuleType() != fieldRuleType || (issueField = IssueField.getById(fieldRule.getFieldId())) != null && fieldRuleType == FieldRule.FieldRuleType.SET && (mutableIssue.getId() == null && issueField.isRequiresExistingIssue() || mutableIssue.getId() != null && !issueField.isRequiresExistingIssue()) || !StringUtils.isNotBlank((String)(value = this.extractValue(fieldRule, email.get(fieldRule), (Issue)mutableIssue)))) continue;
                    IssueFieldSetter issueFieldSetter = null;
                    if (CustomFieldUtil.CUSTOMFIELD_KEY.matcher(fieldRule.getFieldId()).matches()) {
                        CustomField customField = this.customFieldManager.getCustomFieldObject(fieldRule.getFieldId());
                        if (customField != null) {
                            issueFieldSetter = this.customFieldSetters.get(customField.getCustomFieldType().getClass().getName());
                        }
                    } else {
                        issueFieldSetter = this.issueFieldSetters.get(fieldRule.getFieldId());
                    }
                    if (issueFieldSetter == null) continue;
                    issueFieldSetter.write(mutableIssue, fieldRule.getFieldId(), value);
                    issueModified = true;
                    fieldsAlreadyMatched.add(fieldRule.getFieldId());
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Field rule evaluation failed, perhaps Regex syntax is not correct, evaluation continues: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return issueModified;
    }

    @Override
    public Issue lookupIssue(Long projectId, Long issueTypeId, EmailBean email, ApplicationUser user) {
        Issue issue = null;
        FieldContext fieldContext = this.fieldContextDao.resolve(projectId, issueTypeId);
        if (fieldContext != null) {
            IssueType issueType;
            Project project;
            StringBuilder jql = new StringBuilder();
            if (fieldContext.getProjectId() != null && (project = this.projectManager.getProjectObj(fieldContext.getProjectId())) != null) {
                this.append(jql, "project", "=", "\"" + project.getKey() + "\"");
            }
            if (fieldContext.getIssueType() != null && (issueType = this.issueTypeManager.getIssueType(fieldContext.getIssueType().toString())) != null) {
                this.append(jql, "issuetype", "=", "\"" + issueType.getName() + "\"");
            }
            ArrayList<FieldRule> fieldRules = new ArrayList<FieldRule>(Arrays.asList(fieldContext.getFields()));
            Collections.sort(fieldRules, new FieldRule.EntityComparator());
            for (FieldRule fieldRule : fieldRules) {
                try {
                    String value;
                    if (!Boolean.TRUE.equals(fieldRule.isIssueLookupRule()) && FieldRule.FieldRuleType.LOOKUP != fieldRule.getFieldRuleType() || !StringUtils.isNotBlank((String)(value = this.extractValue(fieldRule, email.get(fieldRule), null)))) continue;
                    value = this.escape(value);
                    if (CustomFieldUtil.CUSTOMFIELD_KEY.matcher(fieldRule.getFieldId()).matches()) {
                        CustomField customField = this.customFieldManager.getCustomFieldObject(fieldRule.getFieldId());
                        if (customField == null) continue;
                        if (customField.getCustomFieldType() instanceof RenderableTextCFType) {
                            this.append(jql, "\"" + customField.getName() + "\"", "~", "\"\\\"" + value + "\\\"\"");
                            continue;
                        }
                        this.append(jql, "\"" + customField.getName() + "\"", "=", value);
                        continue;
                    }
                    IssueField issueField = IssueField.getById(fieldRule.getFieldId());
                    if (issueField == null || issueField.getJqlOperator() == null) continue;
                    this.append(jql, issueField.toJqlFragment(value));
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Field rule evaluation failed, perhaps Regex syntax is not correct, evaluation continues: " + e.getMessage()), (Throwable)e);
                }
            }
            if (jql.length() > 0) {
                this.logger.debug((Object)("Lookup issue with JQL : " + jql));
                issue = this.issueSearcher.singleResult(jql.toString(), user);
                if (issue != null) {
                    issue = this.issueManager.getIssueObject(issue.getId());
                }
            }
        }
        return issue;
    }

    @Override
    public boolean transitionIssue(FieldContext fieldContext, Issue issue, EmailBean email, ApplicationUser defaultTransitioningUser) {
        boolean issueModified = false;
        if (fieldContext != null && issue != null && email != null) {
            ArrayList<FieldRule> fieldRules = new ArrayList<FieldRule>(Arrays.asList(fieldContext.getFields()));
            Collections.sort(fieldRules, new FieldRule.EntityComparator());
            for (FieldRule fieldRule : fieldRules) {
                this.logger.info((Object)("Checking field rule for executing transitions: " + fieldRule.getFieldId() + ", " + fieldRule.getRegexp()));
                try {
                    String value;
                    if (fieldRule.getFieldRuleType() != FieldRule.FieldRuleType.WORKFLOW || !StringUtils.isNotBlank((String)(value = this.extractValue(fieldRule, email.get(fieldRule), issue)))) continue;
                    this.logger.debug((Object)("Transition is called with value: " + value));
                    this.issueTransitioner.transitionIssue(issue, value, defaultTransitioningUser);
                    issueModified = true;
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Field rule evaluation failed, perhaps Regex syntax is not correct, evaluation continues: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return issueModified;
    }

    @Override
    public EmailFilterAction filterEmail(FieldContext fieldContext, EmailBean email) {
        EmailFilterAction action = null;
        if (fieldContext != null && email != null) {
            ArrayList<FieldRule> fieldRules = new ArrayList<FieldRule>(Arrays.asList(fieldContext.getFields()));
            Collections.sort(fieldRules, new FieldRule.EntityComparator());
            for (final FieldRule fieldRule : fieldRules) {
                this.logger.info((Object)("Checking field rule for filtering email: " + fieldRule.getFieldId() + ", " + fieldRule.getRegexp()));
                try {
                    if (fieldRule.getFieldRuleType() != FieldRule.FieldRuleType.FILTER || !this.isMatchingRule(fieldRule, email.get(fieldRule))) continue;
                    if ("forward".equalsIgnoreCase(fieldRule.getValue())) {
                        action = new EmailFilterAction(){

                            @Override
                            public void doAction(Message message) throws MessagingException {
                                new EmailForwarder().forward(message, fieldRule.getValueExt());
                            }
                        };
                        continue;
                    }
                    if (!"block".equalsIgnoreCase(fieldRule.getValue())) continue;
                    action = new EmailFilterAction(){

                        @Override
                        public void doAction(Message message) throws MessagingException {
                        }
                    };
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Field rule evaluation failed, perhaps Regex syntax is not correct, evaluation continues: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return action;
    }

    private void append(StringBuilder jql, String field, String operator, String value) {
        if (jql.length() > 0) {
            jql.append(" AND ");
        }
        if (StringUtils.isNotBlank((String)field) && StringUtils.isNotBlank((String)operator) && StringUtils.isNotBlank((String)value)) {
            jql.append(field).append(operator).append(value);
        }
    }

    private void append(StringBuilder jql, String newtoken) {
        if (jql.length() > 0) {
            jql.append(" AND ");
        }
        jql.append(newtoken);
    }

    private String escape(String value) {
        if (value != null) {
            for (String toEscape : this.JQL_CHARACTERS_TO_ESCAPE) {
                if (toEscape.equals("\\")) continue;
                value = value.replaceAll("\\" + toEscape, "\\\\\\\\" + toEscape);
            }
        }
        return value;
    }
}

