/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.security.PermissionManager;
import com.metainf.jira.plugin.emailissue.field.AbstractIssueFieldSetter;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class DuedateSetter
extends AbstractIssueFieldSetter {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final PermissionManager permissionManager;

    public DuedateSetter(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public void write(MutableIssue issue, String field, String value) {
        try {
            Date dateValue = "CURRENT".equalsIgnoreCase(value) ? new Date() : new SimpleDateFormat("yyyyMMdd HH:mm:ss").parse(value);
            Timestamp dueDate = new Timestamp(dateValue.getTime());
            issue.setDueDate(dueDate);
        }
        catch (ParseException e) {
            this.logger.warn((Object)("Date parsing failed: " + e));
        }
    }
}

