/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.metainf.jira.plugin.emailissue.field.CustomFieldSetter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateSetter
extends CustomFieldSetter {
    protected DateSetter(CustomFieldManager customFieldManager) {
        super(customFieldManager);
    }

    @Override
    protected void setValueInIssue(MutableIssue issue, CustomField field, String value) {
        try {
            Date dateValue = "CURRENT".equalsIgnoreCase(value) ? new Date() : new SimpleDateFormat("yyyyMMdd HH:mm:ss").parse(value);
            Timestamp ts = new Timestamp(dateValue.getTime());
            issue.setCustomFieldValue(field, (Object)ts);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Date parsing failed: " + e), (Throwable)e);
        }
    }
}

