/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.metainf.jira.plugin.emailissue.field.AbstractIssueFieldSetter;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class CustomFieldSetter
extends AbstractIssueFieldSetter {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final CustomFieldManager customFieldManager;

    protected CustomFieldSetter(CustomFieldManager customFieldManager) {
        this.customFieldManager = customFieldManager;
    }

    @Override
    public void write(MutableIssue issue, String field, String value) {
        CustomField customField;
        if (issue != null && StringUtils.isNotBlank((CharSequence)value) && (customField = this.getCustomField((Issue)issue, field)) != null) {
            this.logger.debug((Object)("Setting field: " + customField.getName() + " with value: " + value));
            this.setValueInIssue(issue, customField, value);
            this.logger.debug((Object)"Field has been set");
        }
    }

    protected CustomField getCustomField(Issue issue, String field) {
        for (CustomField cf : this.customFieldManager.getCustomFieldObjects(issue)) {
            if (!field.equalsIgnoreCase(cf.getId())) continue;
            return cf;
        }
        return null;
    }

    protected abstract void setValueInIssue(MutableIssue var1, CustomField var2, String var3);
}

