/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.user.ApplicationUser;
import com.metainf.jira.plugin.emailissue.field.AbstractIssueFieldSetter;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class ComponentsSetter
extends AbstractIssueFieldSetter {
    @Override
    public void write(MutableIssue issue, String field, String value) {
        if (issue != null && StringUtils.isNotBlank((CharSequence)value)) {
            ProjectComponent component = null;
            for (ProjectComponent c : issue.getProjectObject().getProjectComponents()) {
                if (!value.equalsIgnoreCase(c.getName())) continue;
                component = c;
                break;
            }
            if (component != null) {
                ArrayList<ProjectComponent> issueComponents = issue.getComponents();
                if (issueComponents == null) {
                    issueComponents = new ArrayList<ProjectComponent>();
                }
                if (!issueComponents.contains(component)) {
                    issueComponents.add(component);
                    issue.setComponent(issueComponents);
                    if (issue.getAssignee() == null && component.getAssigneeType() == 1L && component.getComponentLead() != null && this.isAssignable(issue, component.getComponentLead())) {
                        issue.setAssignee(component.getComponentLead());
                    }
                }
            }
        }
    }

    private boolean isAssignable(MutableIssue issue, ApplicationUser componentLead) {
        boolean assignable = ComponentAccessor.getPermissionManager().hasPermission(ProjectPermissions.ASSIGNABLE_USER, (Issue)issue, componentLead);
        return assignable;
    }
}

