/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.metainf.jira.plugin.emailissue.field.SelectSetter;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class CascadeSelectSetter
extends SelectSetter {
    protected CascadeSelectSetter(CustomFieldManager customFieldManager, OptionsManager optionsManager) {
        super(customFieldManager, optionsManager);
    }

    @Override
    protected void setValueInIssue(MutableIssue issue, CustomField field, String value) {
        String parentOptionValue = value;
        String childOptionValue = null;
        try {
            JSONArray array = new JSONArray(value);
            if (array != null && array.length() > 0) {
                parentOptionValue = array.getString(0);
                childOptionValue = array.length() > 1 ? array.getString(1) : null;
            }
        }
        catch (JSONException e) {
            parentOptionValue = value;
        }
        Option parentOption = this.getOption(issue, field, parentOptionValue);
        Option childOption = null;
        if (parentOption != null) {
            HashMap<String, Option> fieldValue = new HashMap<String, Option>();
            fieldValue.put(null, parentOption);
            if (StringUtils.isNotBlank((String)childOptionValue)) {
                for (Option child : parentOption.getChildOptions()) {
                    if (!childOptionValue.equalsIgnoreCase(child.getValue())) continue;
                    childOption = child;
                    break;
                }
            }
            fieldValue.put("1", childOption);
            issue.setCustomFieldValue(field, fieldValue);
        }
    }
}

