/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.version.Version;
import com.metainf.jira.plugin.emailissue.field.AbstractIssueFieldSetter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class AffectedVersionsSetter
extends AbstractIssueFieldSetter {
    @Override
    public void write(MutableIssue issue, String field, String value) {
        if (issue != null && StringUtils.isNotBlank((CharSequence)value)) {
            Version version = null;
            for (Version v : issue.getProjectObject().getVersions()) {
                if (!value.equalsIgnoreCase(v.getName())) continue;
                version = v;
                break;
            }
            if (version != null) {
                Collection<Version> versionsInIssue = this.getVersionsFromIssue(issue);
                if (versionsInIssue == null) {
                    versionsInIssue = new ArrayList<Version>();
                }
                if (!versionsInIssue.contains(version)) {
                    versionsInIssue.add(version);
                    this.setVersionsInIssue(issue, versionsInIssue);
                }
            }
        }
    }

    protected void setVersionsInIssue(MutableIssue issue, Collection<Version> versionsInIssue) {
        issue.setAffectedVersions(versionsInIssue);
    }

    protected Collection<Version> getVersionsFromIssue(MutableIssue issue) {
        return issue.getAffectedVersions();
    }
}

