/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.field;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.MutableIssue;
import com.metainf.jira.plugin.emailissue.field.IssueFieldSetter;

public abstract class AbstractIssueFieldSetter
implements IssueFieldSetter {
    private final ApplicationProperties applicationProperties;

    protected AbstractIssueFieldSetter() {
        this(ComponentAccessor.getApplicationProperties());
    }

    protected AbstractIssueFieldSetter(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void write(MutableIssue issue, String field, String ... value) {
        if (value != null && value.length > 0) {
            for (String v : value) {
                this.write(issue, field, v);
            }
        }
    }

    public abstract void write(MutableIssue var1, String var2, String var3);

    protected String truncateIfNeeded(String value) {
        String truncatedValue = value;
        try {
            Long maxSize = Long.parseLong(this.applicationProperties.getString("jira.text.field.character.limit"));
            if (maxSize != null && maxSize > 0L && truncatedValue != null && (long)truncatedValue.length() > maxSize) {
                truncatedValue = truncatedValue.substring(0, maxSize.intValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return truncatedValue;
    }
}

