/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.events;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.google.common.collect.Sets;
import com.metainf.jira.plugin.emailissue.entity.DefaultTemplate;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.template.EmailTemplateTheme;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public enum ServiceDeskEvent {
    REQUEST_CREATED(100L, "Request Created", "Service Desk Request Created", EmailTemplateTheme.SD_REQUEST_CREATED, Sets.newHashSet((Object[])new Long[]{EventType.ISSUE_CREATED_ID})),
    REQUEST_UPDATED(101L, "Request Updated", "Service Desk Request Updated", EmailTemplateTheme.SD_REQUEST_UPDATED, Sets.newHashSet((Object[])new Long[]{EventType.ISSUE_UPDATED_ID})),
    REQUEST_RESOLVED(102L, "Request Resolved", "Service Desk Request Resolved", EmailTemplateTheme.SD_REQUEST_RESOLVED, Sets.newHashSet((Object[])new Long[]{EventType.ISSUE_RESOLVED_ID})),
    REQUEST_REOPENED(103L, "Request Reopened", "Service Desk Request Reopened", EmailTemplateTheme.SD_REQUEST_REOPENED, Sets.newHashSet((Object[])new Long[]{EventType.ISSUE_REOPENED_ID})),
    REQUEST_COMMENTED_ADDED(104L, "Public Comment Added", "Public Comment added to Service Desk Request", EmailTemplateTheme.SD_REQUEST_COMMENTED, Sets.newHashSet((Object[])new Long[]{EventType.ISSUE_COMMENTED_ID, EventType.ISSUE_COMMENT_EDITED_ID}));

    private long id;
    private String name;
    private String description;
    private EmailTemplateTheme emailTemplateTheme;
    private Set<Long> issueEvents;
    private static Set<Long> allIssueEventsForServiceDesk;

    private ServiceDeskEvent(long id, String name, String description, EmailTemplateTheme emailTemplateTheme, Set<Long> issueEvents) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.emailTemplateTheme = emailTemplateTheme;
        this.issueEvents = issueEvents;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public EventType toEventType() {
        return new EventType(Long.valueOf(this.getId()), this.getName(), this.getDescription(), Long.valueOf(0L));
    }

    public EmailTemplateTheme getTemplateTheme() {
        return this.emailTemplateTheme;
    }

    public Template getDefaultTemplate() {
        return DefaultTemplate.fromTheme(this.getTemplateTheme());
    }

    public static List<EventType> toEventTypes() {
        LinkedList<EventType> eventTypes = new LinkedList<EventType>();
        for (ServiceDeskEvent sde : ServiceDeskEvent.values()) {
            eventTypes.add(sde.toEventType());
        }
        return eventTypes;
    }

    public static List<EmailTemplateTheme> getTemplateThemes() {
        LinkedList<EmailTemplateTheme> themes = new LinkedList<EmailTemplateTheme>();
        for (ServiceDeskEvent sde : ServiceDeskEvent.values()) {
            themes.add(sde.getTemplateTheme());
        }
        return themes;
    }

    public static ServiceDeskEvent byId(long id) {
        for (ServiceDeskEvent sde : ServiceDeskEvent.values()) {
            if (sde.getId() != id) continue;
            return sde;
        }
        return null;
    }

    public static ServiceDeskEvent byIdOr(long id, ServiceDeskEvent defaultValue) {
        ServiceDeskEvent e = ServiceDeskEvent.byId(id);
        return e == null ? defaultValue : e;
    }

    public static ServiceDeskEvent byIssueEvent(IssueEvent issueEvent) {
        for (ServiceDeskEvent sde : ServiceDeskEvent.values()) {
            if (!sde.issueEvents.contains(issueEvent.getEventTypeId())) continue;
            return sde;
        }
        return null;
    }

    public boolean isIncludesEvent(Long eventTypeId) {
        return this.issueEvents.contains(eventTypeId);
    }

    public static boolean isValidForServiceDesk(IssueEvent issueEvent) {
        return issueEvent != null && allIssueEventsForServiceDesk.contains(issueEvent.getEventTypeId());
    }

    static {
        allIssueEventsForServiceDesk = new HashSet<Long>();
        for (ServiceDeskEvent sde : ServiceDeskEvent.values()) {
            allIssueEventsForServiceDesk.addAll(sde.issueEvents);
        }
    }
}

