/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.events;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.metainf.jira.plugin.emailissue.action.AddAttachmentType;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.action.EmailSource;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.action.config.IssueField;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.entity.Context;
import com.metainf.jira.plugin.emailissue.entity.ContextDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationEvent;
import com.metainf.jira.plugin.emailissue.entity.NotificationRecipient;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplate;
import com.metainf.jira.plugin.emailissue.entity.RuleProcessorType;
import com.metainf.jira.plugin.emailissue.events.EventProcessor;
import com.metainf.jira.plugin.emailissue.events.ServiceDeskEvent;
import com.metainf.jira.plugin.emailissue.mail.EmailSender;
import com.metainf.jira.plugin.emailissue.searcher.IssueSearcher;
import com.metainf.jira.plugin.emailissue.template.MailTemplateManager;
import com.metainf.jira.plugin.emailissue.util.AnonymousUser;
import com.metainf.jira.plugin.emailissue.util.CollectionUtils;
import com.metainf.jira.plugin.emailissue.workflow.EmailDefinitionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class EventProcessorImpl
implements EventProcessor {
    private static final String JQL_PATTERN = "({0}) AND (issuekey={1})";
    private Logger logger = Logger.getLogger(this.getClass());
    private final ContextDao contextDao;
    private final EmailSender emailSender;
    private final JiraAuthenticationContext authContext;
    private final GroupManager groupManager;
    private final ProjectRoleManager projectRoleManager;
    private final CustomFieldManager customFieldManager;
    private final MailTemplateManager mailTemplateManager;
    private final UserPreferencesManager userPreferencesManager;
    private final IssueIndexManager issueIndexManager;
    private final SearchService searchService;
    private final IssueSearcher issueSearcher;
    private final IssueManager issueManager;
    private final ServiceDeskManager serviceDeskManager;

    public EventProcessorImpl(UserPreferencesManager userPreferencesManager, ContextDao contextDao, EmailSender emailBuilder, JiraAuthenticationContext authContext, GroupManager groupManager, ProjectRoleManager projectRoleManager, CustomFieldManager customFieldManager, MailTemplateManager mailTemplateManager, IssueIndexManager issueIndexManager, SearchService searchService, IssueSearcher issueSearcher, IssueManager issueManager, ServiceDeskManager serviceDeskManager) {
        this.contextDao = contextDao;
        this.authContext = authContext;
        this.emailSender = emailBuilder;
        this.groupManager = groupManager;
        this.projectRoleManager = projectRoleManager;
        this.customFieldManager = customFieldManager;
        this.mailTemplateManager = mailTemplateManager;
        this.userPreferencesManager = userPreferencesManager;
        this.searchService = searchService;
        this.issueIndexManager = issueIndexManager;
        this.issueSearcher = issueSearcher;
        this.issueManager = issueManager;
        this.serviceDeskManager = serviceDeskManager;
    }

    @Override
    public void processIssueEvent(IssueEvent issueEvent) {
        this.processIssueEvent(issueEvent, true);
    }

    @Override
    public void processIssueEventSynchronously(IssueEvent issueEvent) {
        this.processIssueEvent(issueEvent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIssueEvent(IssueEvent issueEvent, boolean reindexIssue) {
        block17: {
            try {
                ApplicationUser loggedInUser = issueEvent.getUser();
                if (loggedInUser == null) {
                    loggedInUser = new AnonymousUser();
                }
                if (!issueEvent.isSendMail()) {
                    return;
                }
                if (issueEvent == null || issueEvent.getIssue() == null) break block17;
                try {
                    Context context;
                    MutableIssue refreshedFromDb = this.issueManager.getIssueObject(issueEvent.getIssue().getId());
                    if (refreshedFromDb == null) {
                        refreshedFromDb = issueEvent.getIssue();
                    }
                    if (reindexIssue) {
                        this.issueSearcher.reIndexIssue((Issue)refreshedFromDb);
                    }
                    if ((context = this.mailTemplateManager.resolveContext((Issue)refreshedFromDb, this.contextDao)) != null && context.getNotification() != null && !Boolean.TRUE.equals(context.getNotification().getDisabled())) {
                        boolean serviceDeskProject = this.serviceDeskManager.isServiceDeskProject(refreshedFromDb.getProjectId());
                        RuleProcessorType ruleProcessorType = context.getNotification().getRuleProcessorType();
                        ruleProcessorType = ruleProcessorType == null ? RuleProcessorType.PROCESS_FIRST_MATCHING : ruleProcessorType;
                        List<NotificationEvent> matchingEvents = Collections.EMPTY_LIST;
                        matchingEvents = context.getNotification().hasNotificationForEvent(issueEvent) ? this.resolveNotification(context.getNotification(), issueEvent.getEventTypeId(), issueEvent, (Issue)refreshedFromDb, ruleProcessorType, serviceDeskProject) : this.resolveNotification(context.getNotification(), NotificationEvent.DEFAULT_EVENT_TYPE.getId(), issueEvent, (Issue)refreshedFromDb, ruleProcessorType, serviceDeskProject);
                        if (matchingEvents != null && !matchingEvents.isEmpty()) {
                            for (NotificationEvent event : matchingEvents) {
                                EmailDefinition emailDefinition = this.buildEmailDefinition(event, (Issue)refreshedFromDb, issueEvent, loggedInUser);
                                this.emailSender.sendEmailAsync(emailDefinition, loggedInUser);
                            }
                        }
                    }
                }
                finally {
                    if (issueEvent.getEventTypeId() == EventType.ISSUE_DELETED_ID) {
                        try {
                            this.issueIndexManager.deIndex(issueEvent.getIssue());
                        }
                        catch (IndexException indexException) {}
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIssueIncludedInEventFilter(Long eventTypeId, IssueEvent issueEvent, Issue issue, NotificationEvent event, HashSet<String> changedFields) {
        boolean included = true;
        if (StringUtils.isNotBlank((String)event.getJQLFilter())) {
            try {
                included = this.issueSearcher.issueMatchesJQL(event.getJQLFilter(), issue, true);
            }
            catch (Exception exception) {
            }
            finally {
                if (eventTypeId == EventType.ISSUE_DELETED_ID) {
                    try {
                        this.issueIndexManager.deIndex(issue);
                    }
                    catch (IndexException indexException) {}
                }
            }
        }
        if (included && StringUtils.isNotBlank((String)event.getChangelogFilter()) && issueEvent.getChangeLog() != null) {
            included = false;
            for (String changelogFieldFilter : event.getChangelogFilterNames()) {
                if (changelogFieldFilter == null) continue;
                if (IssueField.COMMENT.getId().equals(changelogFieldFilter) && issueEvent.getComment() != null) {
                    included = true;
                    break;
                }
                if (changelogFieldFilter.startsWith("customfield_")) {
                    CustomField customField = this.customFieldManager.getCustomFieldObject(changelogFieldFilter);
                    if (customField == null || !CollectionUtils.containsIgnoreCase(changedFields, customField.getName()) && !CollectionUtils.containsIgnoreCase(changedFields, customField.getId())) continue;
                    included = true;
                    break;
                }
                IssueField issueField = IssueField.getById(changelogFieldFilter);
                if (issueField == null || !CollectionUtils.containsIgnoreCase(changedFields, issueField.getChangelogFieldName()) && !CollectionUtils.containsIgnoreCase(changedFields, issueField.getId())) continue;
                included = true;
                break;
            }
        }
        return included;
    }

    private HashSet<String> getChangedFields(List<GenericValue> changeItems) {
        HashSet<String> fields = new HashSet<String>();
        for (GenericValue changeItem : changeItems) {
            String field = changeItem.getString("field");
            fields.add(field);
        }
        return fields;
    }

    private List<GenericValue> getChangeItems(GenericValue changeLog) {
        List changeItems = Collections.EMPTY_LIST;
        try {
            if (changeLog != null) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("group", changeLog.get("id"));
                changeItems = changeLog.internalDelegator.findByAnd("ChangeItem", params);
                return changeItems;
            }
        }
        catch (GenericEntityException genericEntityException) {
            // empty catch block
        }
        return changeItems;
    }

    private EmailDefinition buildEmailDefinition(NotificationEvent event, Issue issueFromDb, IssueEvent issueEvent, ApplicationUser loggedInUser) {
        AddAttachmentType aat;
        EmailOptions options = new EmailOptions(event.getEmailOptions());
        ArrayList<Recipient> recipients = new ArrayList<Recipient>();
        ArrayList<Recipient> copyRecipients = new ArrayList<Recipient>();
        ArrayList<Recipient> blindcopyRecipients = new ArrayList<Recipient>();
        String to = null;
        String cc = null;
        String bcc = null;
        for (NotificationRecipient r : event.getRecipients()) {
            Recipient rec;
            if ("to".equals(r.getRecipientType())) {
                if (r.getRecipientKey() != null && r.getRecipientKey().startsWith("to:")) {
                    to = r.getRecipientKey().substring("to".length() + 1);
                    continue;
                }
                rec = Recipient.getRecipientObject(r.getRecipientKey(), this.customFieldManager, this.groupManager, this.projectRoleManager, this.authContext.getI18nHelper());
                if (rec == null) continue;
                recipients.add(rec);
                continue;
            }
            if ("cc".equals(r.getRecipientType())) {
                if (r.getRecipientKey() != null && r.getRecipientKey().startsWith("cc:")) {
                    cc = r.getRecipientKey().substring("cc".length() + 1);
                    continue;
                }
                rec = Recipient.getRecipientObject(r.getRecipientKey(), this.customFieldManager, this.groupManager, this.projectRoleManager, this.authContext.getI18nHelper());
                if (rec == null) continue;
                copyRecipients.add(rec);
                continue;
            }
            if (!"bcc".equals(r.getRecipientType())) continue;
            if (r.getRecipientKey() != null && r.getRecipientKey().startsWith("bcc:")) {
                bcc = r.getRecipientKey().substring("bcc".length() + 1);
                continue;
            }
            rec = Recipient.getRecipientObject(r.getRecipientKey(), this.customFieldManager, this.groupManager, this.projectRoleManager, this.authContext.getI18nHelper());
            if (rec == null) continue;
            blindcopyRecipients.add(rec);
        }
        EmailDefinitionImpl def = new EmailDefinitionImpl(issueFromDb, recipients, copyRecipients, blindcopyRecipients, options, event.getEmailBody(), event.getEmailSubject(), loggedInUser, to, cc, bcc, this.authContext.getI18nHelper(), null, EmailSource.EVENT);
        def.setCustomerNotification(event.isServiceDeskCustomerNotification());
        if (StringUtils.isNotEmpty((String)event.getAddAttachmentsType()) && !AddAttachmentType.NONE.name().equalsIgnoreCase(event.getAddAttachmentsType()) && (aat = AddAttachmentType.getByName(event.getAddAttachmentsType())) != null) {
            def.setAttachmentObjects(aat.filterAttachments(issueFromDb, null).toArray(new Attachment[0]));
        }
        def.setEmailTemplate(event.getTemplate());
        if (event.isServiceDeskCustomerNotification() && event.getTemplate() == null) {
            ServiceDeskEvent serviceDeskEvent = event.getServiceDeskEventTypes().iterator().next();
            def.setEmailTemplate(serviceDeskEvent.getDefaultTemplate());
        }
        if (issueEvent.getEventTypeId() == EventType.ISSUE_COMMENTED_ID || issueEvent.getEventTypeId() == EventType.ISSUE_COMMENT_EDITED_ID) {
            options.setSuppressCommentEvent(true);
        }
        def.setIssueEvent(issueEvent);
        if (issueEvent.getComment() != null) {
            def.setComment(issueEvent.getComment().getBody());
            def.setCommentObject(issueEvent.getComment());
        }
        return def;
    }

    public List<NotificationEvent> resolveNotification(NotificationTemplate notification, Long eventTypeId, IssueEvent issueEvent, Issue issueFromDb, RuleProcessorType ruleProcessorType, boolean serviceDeskProject) {
        LinkedList<NotificationEvent> matchingEventNotifications = new LinkedList<NotificationEvent>();
        boolean publicCommentInEvent = issueEvent.getComment() != null && !this.serviceDeskManager.isInternalComment(issueEvent.getComment());
        boolean customerNotificationMatched = false;
        List<GenericValue> changeItems = this.getChangeItems(issueEvent.getChangeLog());
        HashSet<String> changedFields = this.getChangedFields(changeItems);
        IssueEvent sdIssueEvent = serviceDeskProject ? this.translateEventForServiceDesk(issueFromDb, issueEvent, changeItems) : null;
        List<NotificationEvent> notificationEvents = notification.getEventsSorted();
        for (NotificationEvent event : notificationEvents) {
            IssueEvent eventToResolve;
            if (Boolean.TRUE.equals(event.getDisabled()) || (eventToResolve = serviceDeskProject && event.isServiceDeskCustomerNotification() ? sdIssueEvent : issueEvent) == null || (!NotificationEvent.DEFAULT_EVENT_TYPE.getId().equals(eventTypeId) || !event.isIncludesEventType(eventTypeId)) && !event.isIncludesIssueEvent(eventToResolve) || !this.isIssueIncludedInEventFilter(eventTypeId, eventToResolve, issueFromDb, event, changedFields) || !serviceDeskProject && event.isServiceDeskCustomerNotification() || serviceDeskProject && event.isServiceDeskCustomerNotification() && event.getServiceDeskEventTypes().contains((Object)ServiceDeskEvent.REQUEST_COMMENTED_ADDED) && issueEvent.getComment() != null && !publicCommentInEvent) continue;
            if (event.isCustomerNotification().booleanValue()) {
                customerNotificationMatched = true;
            }
            matchingEventNotifications.add(event);
            if (ruleProcessorType == RuleProcessorType.PROCESS_ALL_MATCHING) continue;
            break;
        }
        if (publicCommentInEvent && serviceDeskProject && !customerNotificationMatched) {
            for (NotificationEvent event : notificationEvents) {
                if (Boolean.TRUE.equals(event.getDisabled()) || matchingEventNotifications.contains(event) || !event.isServiceDeskCustomerNotification() || !event.getServiceDeskEventTypes().contains((Object)ServiceDeskEvent.REQUEST_COMMENTED_ADDED)) continue;
                matchingEventNotifications.add(event);
            }
        }
        return matchingEventNotifications;
    }

    private IssueEvent translateEventForServiceDesk(Issue issueFromDb, IssueEvent issueEvent, List<GenericValue> changeItems) {
        IssueEvent translatedEvent = null;
        if (ServiceDeskEvent.isValidForServiceDesk(issueEvent)) {
            GenericValue resolutionChangeItem;
            translatedEvent = issueEvent;
            if (EventType.ISSUE_UPDATED_ID.equals(issueEvent.getEventTypeId()) && (resolutionChangeItem = this.getChangeItem(changeItems, "resolution")) != null) {
                String oldValue = resolutionChangeItem.getString("oldstring");
                String newValue = resolutionChangeItem.getString("newstring");
                if (StringUtils.isEmpty((String)oldValue) && StringUtils.isNotEmpty((String)newValue)) {
                    translatedEvent = new IssueEvent(issueFromDb, issueEvent.getUser(), issueEvent.getComment(), issueEvent.getWorklog(), issueEvent.getChangeLog(), issueEvent.getParams(), EventType.ISSUE_RESOLVED_ID, issueEvent.isSendMail(), issueEvent.isSubtasksUpdated());
                } else if (StringUtils.isNotEmpty((String)oldValue) && StringUtils.isEmpty((String)newValue)) {
                    translatedEvent = new IssueEvent(issueFromDb, issueEvent.getUser(), issueEvent.getComment(), issueEvent.getWorklog(), issueEvent.getChangeLog(), issueEvent.getParams(), EventType.ISSUE_REOPENED_ID, issueEvent.isSendMail(), issueEvent.isSubtasksUpdated());
                }
            }
        }
        return translatedEvent;
    }

    private GenericValue getChangeItem(List<GenericValue> changeItems, String fieldName) {
        for (GenericValue changeItem : changeItems) {
            if (!changeItem.getString("field").equalsIgnoreCase(fieldName)) continue;
            return changeItem;
        }
        return null;
    }
}

