/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.entity;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.metainf.jira.plugin.emailissue.entity.GenericDao;
import com.metainf.jira.plugin.emailissue.entity.Template;
import java.util.Collection;
import java.util.TreeSet;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.lang.StringUtils;

public class TemplateDao
extends GenericDao<Template> {
    public TemplateDao(ActiveObjects ao) {
        super(ao);
    }

    public Template copy(final Template template) {
        return (Template)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Template>(){

            public Template doInTransaction() {
                Template copy = (Template)TemplateDao.this.ao.create(Template.class, new DBParam[0]);
                copy.setName("Copy of " + template.getName());
                copy.setDescription(template.getDescription());
                copy.setSubject(template.getSubject());
                copy.setHtml(template.getHtml());
                copy.setText(template.getText());
                copy.setLabels(template.getLabels());
                copy.setTheme(template.getTheme());
                copy.save();
                return copy;
            }
        });
    }

    public Template[] filter(String filter) {
        if (StringUtils.isEmpty((String)filter)) {
            return (Template[])this.findAll();
        }
        filter = "%" + filter + "%";
        return (Template[])this.ao.find(Template.class, Query.select().where("NAME LIKE ? OR LABELS LIKE ?", new Object[]{filter, filter}));
    }

    @Override
    protected Class<Template> getPersistentClass() {
        return Template.class;
    }

    public Collection<String> getAllCategories() {
        TreeSet<String> categories = new TreeSet<String>();
        for (Template t : (Template[])this.findAll()) {
            if (!StringUtils.isNotBlank((String)t.getLabels())) continue;
            categories.add(t.getLabels());
        }
        return categories;
    }
}

