/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.entity;

import com.atlassian.jira.ofbiz.OfBizDelegator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;

public class OfBizDao {
    private final OfBizDelegator ofBizDelegator;
    private Logger logger = Logger.getLogger(this.getClass());

    public OfBizDao(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T findFirst(String sql, ResultReader<T> reader) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        T value = null;
        try {
            this.logger.info((Object)("SD SQL: " + sql));
            conn = this.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (reader != null && rs.next()) {
                this.logger.info((Object)"SD SQL: result found");
                value = reader.read(rs);
            }
            this.close(rs);
            this.close(stmt);
            this.close(conn);
        }
        catch (Exception e) {
            try {
                this.logger.info((Object)e.getMessage(), (Throwable)e);
                this.close(rs);
                this.close(stmt);
                this.close(conn);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> findAll(String sql, ResultReader<T> reader) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        LinkedList<T> value = new LinkedList<T>();
        try {
            this.logger.info((Object)("SD SQL: " + sql));
            conn = this.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (reader != null) {
                this.logger.info((Object)"SD SQL: result found");
                while (rs.next()) {
                    value.add(reader.read(rs));
                }
            }
            this.close(rs);
            this.close(stmt);
            this.close(conn);
        }
        catch (Exception e) {
            try {
                this.logger.info((Object)e.getMessage(), (Throwable)e);
                this.close(rs);
                this.close(stmt);
                this.close(conn);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        return value;
    }

    private Connection getConnection() throws SQLException, GenericEntityException {
        String helperName = this.ofBizDelegator.getDelegatorInterface().getGroupHelperName("default");
        Connection conn = ConnectionFactory.getConnection((String)helperName);
        return conn;
    }

    public String getDbDriver() {
        String driver = null;
        try {
            Connection conn = this.getConnection();
            if (conn != null) {
                driver = conn.getMetaData().getDriverName();
            }
        }
        catch (SQLException sQLException) {
        }
        catch (GenericEntityException genericEntityException) {
            // empty catch block
        }
        return driver;
    }

    private void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void close(ResultSet stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface ResultReader<T> {
        public T read(ResultSet var1) throws SQLException;
    }
}

