/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.entity;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.metainf.jira.plugin.emailissue.entity.NotificationEvent;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class NotificationTemplateImpl {
    private NotificationTemplate delegate;
    private EventTypeManager eventTypeManager = ComponentAccessor.getEventTypeManager();

    public NotificationTemplateImpl(NotificationTemplate delegate) {
        this.delegate = delegate;
    }

    public NotificationEvent getNotificationForEventType(IssueEvent issueEvent) {
        NotificationEvent result = null;
        try {
            for (NotificationEvent event : this.getEventsSorted()) {
                if (!event.isIncludesIssueEvent(issueEvent)) continue;
                result = event;
                break;
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean hasNotificationForEvent(IssueEvent issueEvent) {
        NotificationEvent result = this.getNotificationForEventType(issueEvent);
        return result != null;
    }

    public List<NotificationEvent> getEventsSorted() {
        ArrayList<NotificationEvent> result = new ArrayList<NotificationEvent>();
        NotificationEvent[] events = this.delegate.getEvents();
        if (events != null && events.length > 0) {
            result.addAll(Arrays.asList(events));
            Collections.sort(result, new NotificationEvent.EntityComparator());
        }
        return result;
    }

    public List<EventType> getUnassignedEventTypes() {
        ArrayList<EventType> types = new ArrayList<EventType>(this.eventTypeManager.getEventTypes());
        if (this.delegate != null) {
            NotificationEvent[] definedEvents = this.delegate.getEvents();
            HashSet<Long> definedEventTypeIds = new HashSet<Long>();
            for (NotificationEvent ne : definedEvents) {
                for (EventType eventType : ne.getEventTypes()) {
                    definedEventTypeIds.add(eventType.getId());
                }
            }
            Iterator<EventType> it = types.iterator();
            while (it.hasNext()) {
                if (!definedEventTypeIds.contains(it.next().getId())) continue;
                it.remove();
            }
            if (!definedEventTypeIds.contains(0L)) {
                types.add(0, NotificationEvent.DEFAULT_EVENT_TYPE);
            }
        }
        return types;
    }
}

