/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.entity;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.metainf.jira.plugin.emailissue.entity.GenericDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationEvent;
import com.metainf.jira.plugin.emailissue.entity.NotificationEventDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationRecipientDao;
import com.metainf.jira.plugin.emailissue.entity.NotificationTemplate;
import com.metainf.jira.plugin.emailissue.entity.RuleProcessorType;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class NotificationTemplateDao
extends GenericDao<NotificationTemplate> {
    private NotificationEventDao notificationEventDao;
    private final NotificationRecipientDao notificationRecipientDao;

    public NotificationTemplateDao(ActiveObjects ao, NotificationEventDao notificationEventDao, NotificationRecipientDao notificationRecipientDao) {
        super(ao);
        this.notificationEventDao = notificationEventDao;
        this.notificationRecipientDao = notificationRecipientDao;
    }

    public NotificationTemplate create(final String name, final String description, final RuleProcessorType ruleProcessorType) {
        return (NotificationTemplate)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<NotificationTemplate>(){

            public NotificationTemplate doInTransaction() {
                NotificationTemplate template = (NotificationTemplate)NotificationTemplateDao.this.ao.create(NotificationTemplate.class, new DBParam[0]);
                template.setName(name);
                template.setDescription(description);
                template.setRuleProcessorType(ruleProcessorType);
                template.save();
                return template;
            }
        });
    }

    @Override
    public void delete(final NotificationTemplate entity) {
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                NotificationEvent[] events;
                for (NotificationEvent e : events = entity.getEvents()) {
                    NotificationTemplateDao.this.notificationEventDao.delete(e);
                }
                NotificationTemplateDao.this.ao.delete(new RawEntity[]{entity});
                return null;
            }
        });
    }

    @Override
    protected Class<NotificationTemplate> getPersistentClass() {
        return NotificationTemplate.class;
    }

    public NotificationTemplate clone(final NotificationTemplate notification) {
        return (NotificationTemplate)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<NotificationTemplate>(){

            public NotificationTemplate doInTransaction() {
                NotificationTemplate clone = NotificationTemplateDao.this.create("Copy of " + notification.getName(), notification.getDescription(), notification.getRuleProcessorType());
                clone.save();
                for (NotificationEvent ne : notification.getEvents()) {
                    NotificationEvent notificationEvent = NotificationTemplateDao.this.notificationEventDao.clone(clone, ne);
                }
                return clone;
            }
        });
    }
}

