/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.entity;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.entity.NotificationEvent;
import com.metainf.jira.plugin.emailissue.entity.NotificationRecipient;
import com.metainf.jira.plugin.emailissue.events.ServiceDeskEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class NotificationEventImpl {
    private NotificationEvent delegate;
    private EventTypeManager eventTypeManager = ComponentAccessor.getEventTypeManager();
    private GroupManager groupManager = ComponentAccessor.getGroupManager();
    private CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
    private JiraAuthenticationContext authContext = ComponentAccessor.getJiraAuthenticationContext();
    private ProjectRoleManager projectRoleManager = (ProjectRoleManager)ComponentAccessor.getComponentOfType(ProjectRoleManager.class);

    public NotificationEventImpl(NotificationEvent delegate) {
        this.delegate = delegate;
    }

    public Integer getSequenceNumber() {
        return this.delegate.getSequenceNumber() == null ? Integer.valueOf(1) : this.delegate.getSequenceNumber();
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.delegate.setSequenceNumber(sequenceNumber == null ? Integer.valueOf(1) : sequenceNumber);
    }

    public List<String> getRecipientNames() {
        List<String> names = this.recipientNames("to");
        return names;
    }

    public List<String> getCopyRecipientNames() {
        List<String> names = this.recipientNames("cc");
        return names;
    }

    public List<String> getBlindCopyRecipientNames() {
        List<String> names = this.recipientNames("bcc");
        return names;
    }

    protected String getManualRecipients(String type) {
        String manual = null;
        for (NotificationRecipient r : this.delegate.getRecipients()) {
            if (!type.equals(r.getRecipientType()) || !r.getRecipientKey().startsWith(type + ":")) continue;
            manual = r.getRecipientKey().substring(type.length() + 1);
            break;
        }
        return manual;
    }

    public EmailOptions getEmailOptionsObject() {
        return new EmailOptions(this.delegate.getEmailOptions());
    }

    protected List<String> recipientNames(String type) {
        NotificationRecipient[] recipients = this.delegate.getRecipients();
        ArrayList<String> names = new ArrayList<String>();
        for (NotificationRecipient nr : recipients) {
            if (!type.equals(nr.getRecipientType())) continue;
            if (nr.getRecipientKey() != null && nr.getRecipientKey().startsWith(type)) {
                names.add(nr.getRecipientKey().substring(3));
                continue;
            }
            Map<String, Recipient> r = Recipient.buildRecipients(new String[]{nr.getRecipientKey()}, this.customFieldManager, this.groupManager, this.projectRoleManager, this.authContext.getI18nHelper());
            if (r == null || r.isEmpty()) continue;
            names.add(r.values().iterator().next().getDisplayName());
        }
        Collections.sort(names);
        return names;
    }

    public boolean isIncludesEventType(Long eventTypeId) {
        if (eventTypeId != null) {
            for (EventType et : this.getEventTypes()) {
                if (!eventTypeId.equals(et.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isIncludesIssueEvent(IssueEvent issueEvent) {
        if (issueEvent != null) {
            long eventTypeId = issueEvent.getEventTypeId();
            if (this.isServiceDeskCustomerNotification()) {
                for (ServiceDeskEvent serviceDeskEvent : this.getServiceDeskEventTypes()) {
                    if (!serviceDeskEvent.isIncludesEvent(eventTypeId)) continue;
                    return true;
                }
            } else {
                return this.isIncludesEventType(eventTypeId);
            }
        }
        return false;
    }

    private EventType getEventType() {
        try {
            if (this.delegate.getEventTypeId() != null && this.delegate.getEventTypeId() != 0L) {
                if (this.isServiceDeskCustomerNotification()) {
                    ServiceDeskEvent serviceDeskEvent = ServiceDeskEvent.byId(this.delegate.getEventTypeId());
                    return serviceDeskEvent == null ? null : serviceDeskEvent.toEventType();
                }
                return this.eventTypeManager.getEventType(this.delegate.getEventTypeId());
            }
            return NotificationEvent.DEFAULT_EVENT_TYPE;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Set<String> getChangelogFilterNames() {
        HashSet<String> fieldNames = new HashSet<String>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.delegate.getChangelogFilter()})) {
            for (String changelogFilter : this.delegate.getChangelogFilter().split(",")) {
                if (changelogFilter.startsWith("customfield_")) {
                    CustomField cf = this.customFieldManager.getCustomFieldObject(changelogFilter);
                    if (cf == null) continue;
                    fieldNames.add(cf.getName());
                    continue;
                }
                fieldNames.add(changelogFilter);
            }
        }
        return fieldNames;
    }

    public Set<EventType> getEventTypes() {
        HashSet<EventType> eventTypes = new HashSet<EventType>();
        if (StringUtils.isBlank((CharSequence)this.delegate.getEventTypeIds())) {
            EventType eventType = this.getEventType();
            if (eventType != null) {
                eventTypes.add(eventType);
            }
        } else {
            for (String eventTypeId : this.delegate.getEventTypeIds().split(",")) {
                if (NotificationEvent.DEFAULT_EVENT_TYPE.getId().equals(Long.parseLong(eventTypeId))) {
                    eventTypes.add(NotificationEvent.DEFAULT_EVENT_TYPE);
                    continue;
                }
                try {
                    ServiceDeskEvent serviceDeskEvent;
                    EventType eventType = null;
                    eventType = this.isServiceDeskCustomerNotification() ? ((serviceDeskEvent = ServiceDeskEvent.byId(Long.parseLong(eventTypeId))) == null ? null : serviceDeskEvent.toEventType()) : this.eventTypeManager.getEventType(Long.valueOf(Long.parseLong(eventTypeId)));
                    if (eventType == null) continue;
                    eventTypes.add(eventType);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return eventTypes;
    }

    public Set<ServiceDeskEvent> getServiceDeskEventTypes() {
        HashSet<ServiceDeskEvent> eventTypes = new HashSet<ServiceDeskEvent>();
        if (this.isServiceDeskCustomerNotification()) {
            ServiceDeskEvent serviceDeskEvent;
            if (this.delegate.getEventTypeId() != null && this.delegate.getEventTypeId() != 0L && (serviceDeskEvent = ServiceDeskEvent.byId(this.delegate.getEventTypeId())) != null) {
                eventTypes.add(serviceDeskEvent);
            }
            if (StringUtils.isNotBlank((CharSequence)this.delegate.getEventTypeIds())) {
                for (String eventTypeId : this.delegate.getEventTypeIds().split(",")) {
                    ServiceDeskEvent serviceDeskEvent2 = ServiceDeskEvent.byId(Long.parseLong(eventTypeId));
                    if (serviceDeskEvent2 == null) continue;
                    eventTypes.add(serviceDeskEvent2);
                }
            }
        }
        return eventTypes;
    }

    public String getEventTypeNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (EventType et : this.getEventTypes()) {
            names.add(et.getName());
        }
        return StringUtils.join(names, (String)", ");
    }

    public boolean isServiceDeskCustomerNotification() {
        return Boolean.TRUE.equals(this.delegate.isCustomerNotification());
    }
}

